/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener;

import java.util.Collection;
import java.util.Map;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;

public class HttpResponseHeaderBuilder {
    private static final Map<String, String> uniqueHeadersNames;
    private final HttpResponseBuilder responseBuilder;

    public HttpResponseHeaderBuilder(HttpResponseBuilder responseBuilder) {
        this.responseBuilder = responseBuilder;
    }

    public void addHeader(String headerName, Collection<String> headerValue) {
        if (headerValue.size() > 1 || this.responseBuilder.getHeaderValue(headerName).isPresent()) {
            this.failIfHeaderDoesNotSupportMultipleValues(headerName);
        }
        this.responseBuilder.addHeaders(headerName, headerValue);
    }

    public void addHeader(String headerName, String headerValue) {
        this.responseBuilder.getHeaderValue(headerName).ifPresent(value -> this.failIfHeaderDoesNotSupportMultipleValues(headerName));
        this.responseBuilder.addHeader(headerName, headerValue);
    }

    public Collection<String> removeHeader(String headerName) {
        Collection values = this.responseBuilder.getHeaderValues(headerName);
        this.responseBuilder.removeHeader(headerName);
        return values;
    }

    private void failIfHeaderDoesNotSupportMultipleValues(String headerName) {
        if (uniqueHeadersNames.containsKey(headerName)) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Header " + headerName + " does not support multiple values")));
        }
    }

    public String getContentType() {
        return this.getSimpleValue("Content-Type");
    }

    public String getTransferEncoding() {
        return this.getSimpleValue("Transfer-Encoding");
    }

    public String getContentLength() {
        return this.getSimpleValue("Content-Length");
    }

    private String getSimpleValue(String header) {
        return this.responseBuilder.getHeaderValue(header).orElse(null);
    }

    public void addContentType(String multipartFormData) {
        this.addHeader("Content-Type", multipartFormData);
    }

    public void setContentLength(String calculatedContentLength) {
        this.removeHeader("Content-Length");
        this.addHeader("Content-Length", calculatedContentLength);
    }

    static {
        CaseInsensitiveMultiMap uniqueHeadersMap = new CaseInsensitiveMultiMap();
        uniqueHeadersMap.put((Object)"Transfer-Encoding", (Object)"");
        uniqueHeadersMap.put((Object)"Content-Length", (Object)"");
        uniqueHeadersMap.put((Object)"Content-Type", (Object)"");
        uniqueHeadersMap.put((Object)"Access-Control-Allow-Origin", (Object)"");
        uniqueHeadersNames = uniqueHeadersMap;
    }
}

