/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.io.InputStream;
import javax.inject.Inject;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.http.api.request.builder.HttpRequesterRequestBuilder;
import org.mule.extension.http.api.request.client.UriParameters;
import org.mule.extension.http.api.request.validator.ResponseValidator;
import org.mule.extension.http.api.request.validator.SuccessStatusCodeValidator;
import org.mule.extension.http.internal.HttpMetadataResolver;
import org.mule.extension.http.internal.request.ConfigurationOverrides;
import org.mule.extension.http.internal.request.HttpRequester;
import org.mule.extension.http.internal.request.HttpRequesterConfig;
import org.mule.extension.http.internal.request.OffsetCursorProviderWrapper;
import org.mule.extension.http.internal.request.RequestErrorTypeProvider;
import org.mule.extension.http.internal.request.RequestNotificationActionProvider;
import org.mule.extension.http.internal.request.ResponseValidationSettings;
import org.mule.extension.http.internal.request.UriSettings;
import org.mule.extension.http.internal.request.client.HttpExtensionClient;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.extension.api.annotation.Streaming;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.notification.Fires;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.notification.NotificationEmitter;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.utils.HttpEncoderDecoderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestOperations
implements Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestOperations.class);
    private static final int WAIT_FOR_EVER = Integer.MAX_VALUE;
    private static final SuccessStatusCodeValidator DEFAULT_STATUS_CODE_VALIDATOR = new SuccessStatusCodeValidator("0..399");
    private static final HttpRequesterRequestBuilder DEFAULT_REQUEST_BUILDER = new HttpRequesterRequestBuilder();
    private static final HttpRequester REQUESTER = new HttpRequester();
    @Inject
    private MuleContext muleContext;
    @Inject
    private TransformationService transformationService;
    @Inject
    private SchedulerService schedulerService;
    private Scheduler scheduler;

    @Summary(value="Executes a HTTP Request")
    @OutputResolver(output=HttpMetadataResolver.class)
    @Fires(value={RequestNotificationActionProvider.class})
    @Throws(value={RequestErrorTypeProvider.class})
    @Streaming
    @MediaType(value="*/*", strict=false)
    public void request(@Placement(order=1) @ParameterGroup(name="URI Settings") UriSettings uriSettings, @Placement(order=2) @Optional(defaultValue="GET") String method, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, @Placement(order=3) @ParameterGroup(name="Request") HttpRequesterRequestBuilder requestBuilder, @ParameterGroup(name="Response") ResponseValidationSettings responseValidationSettings, @Connection HttpExtensionClient client, @Config HttpRequesterConfig config, CorrelationInfo correlationInfo, NotificationEmitter notificationEmitter, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        try {
            String resolvedUri;
            HttpRequesterRequestBuilder resolvedBuilder = requestBuilder != null ? requestBuilder : DEFAULT_REQUEST_BUILDER;
            this.handleCursor(resolvedBuilder);
            resolvedBuilder.setCorrelationInfo(correlationInfo);
            if (uriSettings.getUrl() == null) {
                UriParameters uriParameters = client.getDefaultUriParameters();
                String resolvedBasePath = config.getBasePath();
                String resolvedPath = resolvedBuilder.replaceUriParams(this.buildPath(resolvedBasePath, uriSettings.getPath()));
                resolvedUri = this.resolveUri(uriParameters.getScheme(), uriParameters.getHost().trim(), uriParameters.getPort(), resolvedPath);
            } else {
                resolvedUri = resolvedBuilder.replaceUriParams(uriSettings.getUrl());
            }
            int resolvedTimeout = this.resolveResponseTimeout(overrides.getResponseTimeout());
            ResponseValidator responseValidator = responseValidationSettings.getResponseValidator();
            responseValidator = responseValidator != null ? responseValidator : DEFAULT_STATUS_CODE_VALIDATOR;
            LOGGER.debug("Sending '{}' request to '{}'.", (Object)method, (Object)resolvedUri);
            REQUESTER.doRequest(client, config, resolvedUri, method, overrides.getRequestStreamingMode(), overrides.getSendBodyMode(), overrides.getFollowRedirects(), client.getDefaultAuthentication(), resolvedTimeout, responseValidator, this.transformationService, resolvedBuilder, true, this.muleContext, this.scheduler, notificationEmitter, streamingHelper, callback);
        }
        catch (Throwable t) {
            callback.error((Throwable)(t instanceof Exception ? (Exception)t : new DefaultMuleException(t)));
        }
    }

    protected void handleCursor(HttpRequesterRequestBuilder resolvedBuilder) {
        if (resolvedBuilder.getBody().getValue() instanceof CursorStream) {
            CursorStream cursor = (CursorStream)resolvedBuilder.getBody().getValue();
            long position = cursor.getPosition();
            CursorStreamProvider provider = (CursorStreamProvider)cursor.getProvider();
            if (position == 0L) {
                resolvedBuilder.setBody((TypedValue<Object>)new TypedValue((Object)provider, resolvedBuilder.getBody().getDataType(), resolvedBuilder.getBody().getByteLength()));
            } else {
                resolvedBuilder.setBody((TypedValue<Object>)new TypedValue((Object)new OffsetCursorProviderWrapper(provider, position), resolvedBuilder.getBody().getDataType(), resolvedBuilder.getBody().getByteLength()));
            }
        }
    }

    private String resolveUri(HttpConstants.Protocol scheme, String host, Integer port, String path) {
        return scheme.getScheme() + "://" + host + ":" + port + HttpEncoderDecoderUtils.encodeSpaces((String)path);
    }

    private int resolveResponseTimeout(Integer responseTimeout) {
        if (this.muleContext.getConfiguration().isDisableTimeouts()) {
            return Integer.MAX_VALUE;
        }
        return responseTimeout != null ? responseTimeout.intValue() : this.muleContext.getConfiguration().getDefaultResponseTimeout();
    }

    protected String buildPath(String basePath, String path) {
        String resolvedBasePath = basePath;
        String resolvedRequestPath = path;
        if (!resolvedBasePath.startsWith("/")) {
            resolvedBasePath = "/" + resolvedBasePath;
        }
        if (resolvedBasePath.endsWith("/") && resolvedRequestPath.startsWith("/")) {
            resolvedBasePath = resolvedBasePath.substring(0, resolvedBasePath.length() - 1);
        }
        if (!(resolvedBasePath.endsWith("/") || resolvedRequestPath.startsWith("/") || resolvedRequestPath.isEmpty())) {
            resolvedBasePath = resolvedBasePath + "/";
        }
        return resolvedBasePath + resolvedRequestPath;
    }

    public void initialise() throws InitialisationException {
        this.scheduler = this.schedulerService.ioScheduler();
    }

    public void dispose() {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
    }
}

