/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.http.api.error.HttpError;
import org.mule.extension.http.api.error.HttpErrorMessageGenerator;
import org.mule.extension.http.api.error.HttpRequestFailedException;
import org.mule.extension.http.api.notification.HttpNotificationAction;
import org.mule.extension.http.api.notification.HttpRequestNotificationData;
import org.mule.extension.http.api.notification.HttpResponseNotificationData;
import org.mule.extension.http.api.request.HttpSendBodyMode;
import org.mule.extension.http.api.request.authentication.HttpRequestAuthentication;
import org.mule.extension.http.api.request.authentication.UsernamePasswordAuthentication;
import org.mule.extension.http.api.request.builder.HttpRequesterRequestBuilder;
import org.mule.extension.http.api.request.client.UriParameters;
import org.mule.extension.http.api.request.validator.ResponseValidator;
import org.mule.extension.http.api.streaming.HttpStreamingType;
import org.mule.extension.http.internal.HttpConnectorConstants;
import org.mule.extension.http.internal.request.HttpRequestFactory;
import org.mule.extension.http.internal.request.HttpRequesterConfig;
import org.mule.extension.http.internal.request.HttpResponseToResult;
import org.mule.extension.http.internal.request.client.HttpExtensionClient;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.notification.NotificationActionDefinition;
import org.mule.runtime.extension.api.notification.NotificationEmitter;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequester {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequester.class);
    private static int RETRY_ATTEMPTS = Integer.getInteger("mule.http.client.maxRetries", 3);
    private static boolean RETRY_ON_ALL_METHODS = Boolean.getBoolean("mule.http.client.retryOnAllMethods");
    private static final DataType REQUEST_NOTIFICATION_DATA_TYPE = DataType.fromType(HttpRequestNotificationData.class);
    private static final DataType RESPONSE_NOTIFICATION_DATA_TYPE = DataType.fromType(HttpResponseNotificationData.class);
    private static final HttpRequestFactory EVENT_TO_HTTP_REQUEST = new HttpRequestFactory();
    private static final HttpResponseToResult RESPONSE_TO_RESULT = new HttpResponseToResult();
    private static final HttpErrorMessageGenerator ERROR_MESSAGE_GENERATOR = new HttpErrorMessageGenerator();
    private static final Method fireNotificationMethod;

    public void doRequest(HttpExtensionClient client, HttpRequesterConfig config, String uri, String method, HttpStreamingType streamingMode, HttpSendBodyMode sendBodyMode, boolean followRedirects, HttpRequestAuthentication authentication, int responseTimeout, ResponseValidator responseValidator, TransformationService transformationService, HttpRequesterRequestBuilder requestBuilder, boolean checkRetry, MuleContext muleContext, Scheduler scheduler, NotificationEmitter notificationEmitter, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        this.doRequestWithRetry(client, config, uri, method, streamingMode, sendBodyMode, followRedirects, authentication, responseTimeout, responseValidator, transformationService, requestBuilder, checkRetry, muleContext, scheduler, notificationEmitter, streamingHelper, callback, EVENT_TO_HTTP_REQUEST.create(config, uri, method, streamingMode, sendBodyMode, transformationService, requestBuilder, authentication), RETRY_ATTEMPTS);
    }

    private void doRequestWithRetry(HttpExtensionClient client, HttpRequesterConfig config, String uri, String method, HttpStreamingType streamingMode, HttpSendBodyMode sendBodyMode, boolean followRedirects, HttpRequestAuthentication authentication, int responseTimeout, ResponseValidator responseValidator, TransformationService transformationService, HttpRequesterRequestBuilder requestBuilder, boolean checkRetry, MuleContext muleContext, Scheduler scheduler, NotificationEmitter notificationEmitter, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback, HttpRequest httpRequest, int retryCount) {
        this.fireNotification(notificationEmitter, HttpNotificationAction.REQUEST_START, () -> HttpRequestNotificationData.from(httpRequest), REQUEST_NOTIFICATION_DATA_TYPE);
        client.send(httpRequest, responseTimeout, followRedirects, this.resolveAuthentication(authentication)).whenComplete((response, exception) -> {
            if (response != null) {
                try {
                    this.fireNotification(notificationEmitter, HttpNotificationAction.REQUEST_COMPLETE, () -> HttpResponseNotificationData.from(response), RESPONSE_NOTIFICATION_DATA_TYPE);
                    Result<InputStream, HttpResponseAttributes> result = RESPONSE_TO_RESULT.convert(config, muleContext, (HttpResponse)response, httpRequest.getUri());
                    this.resendRequest(result, checkRetry, authentication, () -> {
                        scheduler.submit(() -> this.consumePayload(result));
                        this.doRequest(client, config, uri, method, streamingMode, sendBodyMode, followRedirects, authentication, responseTimeout, responseValidator, transformationService, requestBuilder, false, muleContext, scheduler, notificationEmitter, streamingHelper, callback);
                    }, () -> {
                        responseValidator.validate(result, httpRequest, streamingHelper);
                        callback.success(result);
                    });
                }
                catch (Exception e) {
                    callback.error((Throwable)e);
                }
            } else {
                this.checkIfRemotelyClosed((Throwable)exception, client.getDefaultUriParameters());
                if (this.shouldRetryRemotelyClosed((Throwable)exception, retryCount, httpRequest.getMethod())) {
                    this.doRequestWithRetry(client, config, uri, method, streamingMode, sendBodyMode, followRedirects, authentication, responseTimeout, responseValidator, transformationService, requestBuilder, checkRetry, muleContext, scheduler, notificationEmitter, streamingHelper, callback, httpRequest, retryCount - 1);
                    return;
                }
                logger.error(this.getErrorMessage(httpRequest));
                HttpError error = exception instanceof TimeoutException ? HttpError.TIMEOUT : HttpError.CONNECTIVITY;
                callback.error((Throwable)((Object)new HttpRequestFailedException(I18nMessageFactory.createStaticMessage((String)ERROR_MESSAGE_GENERATOR.createFrom(httpRequest, exception.getMessage())), (Throwable)exception, error)));
            }
        });
    }

    private void fireNotification(NotificationEmitter notificationEmitter, NotificationActionDefinition action, Supplier<?> data, DataType dataType) {
        if (fireNotificationMethod != null) {
            try {
                fireNotificationMethod.invoke((Object)notificationEmitter, action, data, dataType);
            }
            catch (InvocationTargetException e) {
                throw new MuleRuntimeException(e.getCause());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                notificationEmitter.fire(action, new TypedValue(data.get(), dataType));
            }
        } else {
            notificationEmitter.fire(action, new TypedValue(data.get(), dataType));
        }
    }

    private String getErrorMessage(HttpRequest httpRequest) {
        return String.format("Error sending HTTP request to %s", httpRequest.getUri());
    }

    private void resendRequest(Result result, boolean retry, HttpRequestAuthentication authentication, Runnable retryCallback, Runnable notRetryCallback) {
        if (retry && authentication != null) {
            authentication.retryIfShould((Result<Object, HttpResponseAttributes>)result, retryCallback, notRetryCallback);
        } else {
            notRetryCallback.run();
        }
    }

    private void consumePayload(Result result) {
        if (result.getOutput() instanceof InputStream) {
            try {
                IOUtils.toByteArray((InputStream)((InputStream)result.getOutput()));
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    private HttpAuthentication resolveAuthentication(HttpRequestAuthentication authentication) {
        HttpAuthentication requestAuthentication = null;
        if (authentication instanceof UsernamePasswordAuthentication) {
            requestAuthentication = (HttpAuthentication)authentication;
        }
        return requestAuthentication;
    }

    private void checkIfRemotelyClosed(Throwable exception, UriParameters uriParameters) {
        if (HttpConstants.Protocol.HTTPS.equals((Object)uriParameters.getScheme()) && StringUtils.containsIgnoreCase((CharSequence)exception.getMessage(), (CharSequence)"Remotely closed")) {
            logger.error("Remote host closed connection. Possible SSL/TLS handshake issue. Check protocols, cipher suites and certificate set up. Use -Djavax.net.debug=ssl for further debugging.");
        }
    }

    private boolean shouldRetryRemotelyClosed(Throwable exception, int retryCount, String httpMethod) {
        boolean shouldRetry;
        boolean bl = shouldRetry = exception instanceof IOException && StringUtils.containsIgnoreCase((CharSequence)exception.getMessage(), (CharSequence)"Remotely closed") && this.supportsRetry(httpMethod) && retryCount > 0;
        if (shouldRetry) {
            logger.warn("Sending HTTP message failed with `" + IOException.class.getCanonicalName() + ": " + "Remotely closed" + "`. Request will be retried " + retryCount + " time(s) before failing.");
        }
        return shouldRetry;
    }

    private boolean supportsRetry(String httpMethod) {
        return RETRY_ON_ALL_METHODS || HttpConnectorConstants.IDEMPOTENT_METHODS.contains(httpMethod);
    }

    public static void refreshSystemProperties() {
        RETRY_ATTEMPTS = Integer.getInteger("mule.http.client.maxRetries", 3);
        RETRY_ON_ALL_METHODS = Boolean.getBoolean("mule.http.client.retryOnAllMethods");
    }

    static {
        Method fireLazy = null;
        try {
            fireLazy = NotificationEmitter.class.getDeclaredMethod("fireLazy", NotificationActionDefinition.class, Supplier.class, DataType.class);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        fireNotificationMethod = fireLazy;
    }
}

