/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class HttpRequesterConnectionManager
implements Disposable {
    @Inject
    private HttpService httpService;
    private Map<String, ShareableHttpClient> clients = new HashMap<String, ShareableHttpClient>();

    public HttpRequesterConnectionManager() {
    }

    public HttpRequesterConnectionManager(HttpService httpService) {
        this.httpService = httpService;
    }

    public Optional<ShareableHttpClient> lookup(String configName) {
        return Optional.ofNullable(this.clients.get(configName));
    }

    public synchronized ShareableHttpClient create(String configName, HttpClientConfiguration clientConfiguration) {
        Preconditions.checkArgument((!this.clients.containsKey(configName) ? 1 : 0) != 0, (String)String.format("There's an HttpClient available for %s already.", configName));
        ShareableHttpClient client = new ShareableHttpClient(this.httpService.getClientFactory().create(clientConfiguration));
        this.clients.put(configName, client);
        return client;
    }

    public void dispose() {
        this.clients.clear();
    }

    public class ShareableHttpClient {
        private HttpClient delegate;
        private Integer usageCount = new Integer(0);

        ShareableHttpClient(HttpClient client) {
            this.delegate = client;
        }

        public synchronized void start() {
            this.usageCount = this.usageCount + 1;
            if (this.usageCount == 1) {
                try {
                    this.delegate.start();
                }
                catch (Exception e) {
                    Integer n = this.usageCount;
                    Integer n2 = this.usageCount = Integer.valueOf(this.usageCount - 1);
                    throw e;
                }
            }
        }

        public synchronized void stop() {
            this.usageCount = this.usageCount - 1;
            if (this.usageCount == 0) {
                this.delegate.stop();
            }
        }

        public CompletableFuture<HttpResponse> sendAsync(HttpRequest request, int responseTimeout, boolean followRedirects, HttpAuthentication authentication) {
            return this.delegate.sendAsync(request, responseTimeout, followRedirects, authentication);
        }
    }
}

