/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.http.internal.request.HttpRequesterCookieConfig;
import org.mule.extension.http.internal.request.builder.HttpResponseAttributesBuilder;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseToResult {
    private static final Logger logger = LoggerFactory.getLogger(HttpResponseToResult.class);
    private static final String BINARY_CONTENT_TYPE = MediaType.BINARY.toRfcString();
    private static boolean STRICT_CONTENT_TYPE = Boolean.parseBoolean(System.getProperty("mule.strictContentType"));
    private final Function<String, MediaType> parseMediaType = ClassUtils.memoize(ctv -> this.parseMediaType((String)ctv), new ConcurrentHashMap());

    public Result<InputStream, HttpResponseAttributes> convert(HttpRequesterCookieConfig config, MuleContext muleContext, HttpResponse response, URI uri) {
        String responseContentType = response.getHeaderValue("Content-Type");
        HttpEntity entity = response.getEntity();
        if (StringUtils.isEmpty((String)responseContentType) && !this.empty(entity)) {
            responseContentType = BINARY_CONTENT_TYPE;
        }
        MediaType responseMediaType = this.getMediaType(responseContentType, SystemUtils.getDefaultEncoding((MuleContext)muleContext));
        if (config.isEnableCookies()) {
            this.processCookies(config, response, uri);
        }
        HttpResponseAttributes responseAttributes = this.createAttributes(response);
        Result.Builder builder = Result.builder();
        builder.mediaType(responseMediaType);
        if (entity.getLength().isPresent()) {
            builder.length((Long)entity.getLength().get());
        }
        return builder.output((Object)entity.getContent()).attributes((Object)responseAttributes).build();
    }

    private boolean empty(HttpEntity entity) {
        return entity.getLength().filter(length -> length <= 0L).isPresent();
    }

    private HttpResponseAttributes createAttributes(HttpResponse response) {
        return new HttpResponseAttributesBuilder().setResponse(response).build();
    }

    private void processCookies(HttpRequesterCookieConfig config, HttpResponse response, URI uri) {
        Collection setCookieHeader = response.getHeaderValues("Set-Cookie");
        Collection setCookie2Header = response.getHeaderValues("Set-Cookie2");
        HashMap<String, List<String>> cookieHeaders = new HashMap<String, List<String>>();
        if (setCookieHeader != null) {
            cookieHeaders.put("Set-Cookie", new ArrayList(setCookieHeader));
        }
        if (setCookie2Header != null) {
            cookieHeaders.put("Set-Cookie2", new ArrayList(setCookie2Header));
        }
        try {
            config.getCookieManager().put(uri, cookieHeaders);
        }
        catch (IOException e) {
            logger.warn("Error storing cookies for URI " + uri, (Throwable)e);
        }
    }

    private MediaType getMediaType(String contentTypeValue, Charset defaultCharset) {
        MediaType mediaType = contentTypeValue != null ? this.parseMediaType.apply(contentTypeValue) : MediaType.ANY;
        if (!mediaType.getCharset().isPresent()) {
            return mediaType.withCharset(defaultCharset);
        }
        return mediaType;
    }

    private MediaType parseMediaType(String contentTypeValue) {
        try {
            return MediaType.parse((String)contentTypeValue);
        }
        catch (IllegalArgumentException e) {
            if (STRICT_CONTENT_TYPE) {
                throw e;
            }
            logger.warn(String.format("%s when parsing Content-Type '%s': %s", e.getClass().getName(), contentTypeValue, e.getMessage()));
            logger.warn(String.format("Using default encoding: %s", Charset.defaultCharset().name()));
            return MediaType.ANY;
        }
    }

    public static void refreshSystemProperties() {
        STRICT_CONTENT_TYPE = Boolean.parseBoolean(System.getProperty("mule.strictContentType"));
    }
}

