/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request.client;

import org.mule.extension.http.api.request.client.UriParameters;
import org.mule.runtime.http.api.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUriParameters
implements UriParameters {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultUriParameters.class);
    private final HttpConstants.Protocol scheme;
    private final String host;
    private final Integer port;

    public DefaultUriParameters(HttpConstants.Protocol protocol, String host, Integer port) {
        this.scheme = protocol;
        this.host = host;
        this.port = this.getValidPort(protocol, host, port);
    }

    @Override
    public HttpConstants.Protocol getScheme() {
        return this.scheme;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    private int getValidPort(HttpConstants.Protocol protocol, String host, Integer configuredPort) {
        int defaultProtocolPort = protocol.getDefaultPort();
        if (configuredPort == null) {
            return defaultProtocolPort;
        }
        if (configuredPort < 0) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Invalid port: " + configuredPort + " for host " + host + ", defaulting to " + defaultProtocolPort);
            }
            return defaultProtocolPort;
        }
        return configuredPort;
    }
}

