/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api;

import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.security.cert.Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.mule.extension.socket.api.SocketAttributes;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableSocketAttributes
implements SocketAttributes,
Serializable {
    private static final long serialVersionUID = 1991548360970880784L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmutableSocketAttributes.class);
    @Parameter
    private int port;
    @Parameter
    private String hostAddress;
    @Parameter
    private String hostName;
    @Parameter
    @Optional
    private Certificate[] localCertificates;
    @Parameter
    @Optional
    private Certificate[] peerCertificates;

    public ImmutableSocketAttributes(Socket socket) {
        block3: {
            this.fromInetAddress(socket.getPort(), socket.getInetAddress());
            if (socket instanceof SSLSocket) {
                try {
                    SSLSocket sslSocket = (SSLSocket)socket;
                    SSLSession sslSession = sslSocket.getSession();
                    this.localCertificates = sslSession.getLocalCertificates();
                    this.peerCertificates = sslSession.getPeerCertificates();
                }
                catch (SSLPeerUnverifiedException e) {
                    if (!LOGGER.isDebugEnabled()) break block3;
                    LOGGER.debug("Error obtaining SSLSocket attributes", (Throwable)e);
                }
            }
        }
    }

    public ImmutableSocketAttributes(DatagramSocket socket) {
        this.fromInetAddress(socket.getPort(), socket.getInetAddress());
    }

    public ImmutableSocketAttributes(DatagramPacket packet) {
        this(packet.getPort(), packet.getAddress().getHostAddress(), packet.getAddress().getHostName());
    }

    private void fromInetAddress(int port, InetAddress address) {
        this.port = port;
        if (address != null) {
            this.hostName = address.getHostName();
            this.hostAddress = address.getHostAddress();
        }
        if (this.hostName == null) {
            this.hostName = "";
        }
        if (this.hostAddress == null) {
            this.hostName = "";
        }
    }

    public ImmutableSocketAttributes(int remotePort, String remoteHostAddress, String remoteHostName) {
        this.port = remotePort;
        this.hostAddress = remoteHostAddress == null ? "" : remoteHostAddress;
        this.hostName = remoteHostName == null ? "" : remoteHostName;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getHostAddress() {
        return this.hostAddress;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public Certificate[] getLocalCertificates() {
        return this.localCertificates;
    }

    @Override
    public Certificate[] getPeerCertificates() {
        return this.peerCertificates;
    }
}

