/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api;

import java.net.InetSocketAddress;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

public class SocketConnectionSettings {
    private static final int PORT_CHOSEN_BY_SYSTEM_MASK = 0;
    @Parameter
    @Placement(order=2)
    private Integer port;
    @Parameter
    @Placement(order=1)
    private String host;

    public SocketConnectionSettings() {
    }

    public SocketConnectionSettings(Integer port, String host) {
        this.port = port;
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public InetSocketAddress getInetSocketAddress() {
        if (this.isEmpty()) {
            return new InetSocketAddress(0);
        }
        if (this.port == null && !StringUtils.isBlank((String)this.host)) {
            return new InetSocketAddress(this.host, 0);
        }
        if (this.port != null && StringUtils.isBlank((String)this.host)) {
            return new InetSocketAddress(this.port);
        }
        return new InetSocketAddress(this.host, (int)this.port);
    }

    public String toString() {
        return String.format("Host %s Port %s", this.host, this.port != null ? this.port.toString() : "");
    }

    private boolean isEmpty() {
        return StringUtils.isBlank((String)this.host) && this.port == null;
    }
}

