/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api.connection.tcp.protocol;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Objects;
import org.mule.extension.socket.api.connection.tcp.protocol.DirectProtocol;
import org.mule.extension.socket.api.socket.tcp.TcpProtocol;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractByteProtocol
implements TcpProtocol {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectProtocol.class);
    private static final long PAUSE_PERIOD = 100L;
    protected static final int EOF = -1;
    protected static final int NO_MAX_LENGTH = -1;
    public static final boolean STREAM_OK = true;
    protected final boolean streamOk;
    public static final boolean NO_STREAM = false;
    @Parameter
    @Optional(defaultValue="false")
    protected boolean rethrowExceptionOnRead = false;

    public AbstractByteProtocol(boolean streamOk) {
        this.streamOk = streamOk;
    }

    protected int safeRead(InputStream is, byte[] buffer) throws IOException {
        return this.safeRead(is, buffer, buffer.length);
    }

    protected int safeRead(InputStream is, byte[] buffer, int size) throws IOException {
        try {
            int len;
            do {
                if (0 != (len = is.read(buffer, 0, size))) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (0 == len);
            return len;
        }
        catch (SocketException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Socket exception occured", (Throwable)e);
            }
            if (this.rethrowExceptionOnRead) {
                throw e;
            }
            return -1;
        }
        catch (SocketTimeoutException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("TCP Socket timed out", (Throwable)e);
            }
            if (this.rethrowExceptionOnRead) {
                throw e;
            }
            return -1;
        }
    }

    protected int copy(InputStream source, byte[] buffer, OutputStream dest) throws IOException {
        return this.copy(source, buffer, dest, buffer.length);
    }

    protected int copy(InputStream source, byte[] buffer, OutputStream dest, int size) throws IOException {
        int len = this.safeRead(source, buffer, size);
        if (len > 0) {
            dest.write(buffer, 0, len);
        }
        return len;
    }

    protected InputStream nullIfEmptyArray(byte[] bytes) {
        return bytes.length == 0 ? null : new ByteArrayInputStream(bytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractByteProtocol that = (AbstractByteProtocol)o;
        return this.streamOk == that.streamOk && this.rethrowExceptionOnRead == that.rethrowExceptionOnRead;
    }

    public int hashCode() {
        return Objects.hash(this.streamOk, this.rethrowExceptionOnRead);
    }
}

