/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api.connection.tcp.protocol;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.mule.extension.socket.api.connection.tcp.protocol.DirectProtocol;
import org.mule.extension.socket.api.exceptions.LengthExceededException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.dsl.xml.TypeDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;

@TypeDsl(allowTopLevelDefinition=true)
public class LengthProtocol
extends DirectProtocol {
    public static final String LENGTH_EXCEEDED = "Message length is '%d' and exceeds the limit '%d";
    private static final int SIZE_INT = 4;
    @Parameter
    @Optional(defaultValue="-1")
    private int maxMessageLength = -1;

    public LengthProtocol() {
        this(-1);
    }

    public LengthProtocol(int maxMessageLength) {
        super(false, 4);
        this.maxMessageLength = maxMessageLength;
    }

    @Override
    public InputStream read(InputStream socketIs) throws IOException {
        return this.nullIfEmptyArray(this.consume(socketIs));
    }

    private byte[] consume(InputStream inputStream) throws IOException {
        DataInputStream dis = new DataInputStream(inputStream);
        dis.mark(4);
        if (null == super.consume(dis, 4)) {
            throw new IOException("Length Protocol could not read ");
        }
        dis.reset();
        int length = dis.readInt();
        if (length < 0 || this.maxMessageLength > 0 && length > this.maxMessageLength) {
            throw new LengthExceededException(String.format(LENGTH_EXCEEDED, length, this.maxMessageLength));
        }
        byte[] buffer = new byte[length];
        dis.readFully(buffer);
        return buffer;
    }

    @Override
    public void write(OutputStream os, InputStream inputStream) throws IOException {
        byte[] data = IOUtils.toByteArray((InputStream)inputStream);
        if (this.maxMessageLength > 0 && data.length > this.maxMessageLength) {
            throw new LengthExceededException(String.format(LENGTH_EXCEEDED, data.length, this.maxMessageLength));
        }
        DataOutputStream dataOutputStream = new DataOutputStream(os);
        dataOutputStream.writeInt(data.length);
        dataOutputStream.write(data);
        if (dataOutputStream.size() != data.length + 4) {
            dataOutputStream.flush();
        }
    }

    @Override
    protected boolean isRepeat(int len, int available) {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LengthProtocol that = (LengthProtocol)o;
        return this.maxMessageLength == that.maxMessageLength;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxMessageLength);
    }
}

