/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api.provider.tcp;

import org.mule.extension.socket.api.SocketConnectionSettings;
import org.mule.extension.socket.api.connection.tcp.TcpListenerConnection;
import org.mule.extension.socket.api.connection.tcp.protocol.SafeProtocol;
import org.mule.extension.socket.api.socket.factory.SimpleServerSocketFactory;
import org.mule.extension.socket.api.socket.factory.SslServerSocketFactory;
import org.mule.extension.socket.api.socket.factory.TcpServerSocketFactory;
import org.mule.extension.socket.api.socket.tcp.TcpProtocol;
import org.mule.extension.socket.api.socket.tcp.TcpServerSocketProperties;
import org.mule.extension.socket.internal.SocketUtils;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@Alias(value="tcp-listener")
public final class TcpListenerProvider
implements CachedConnectionProvider<TcpListenerConnection>,
Initialisable {
    @Parameter
    @Optional
    @DisplayName(value="TLS Configuration")
    @Placement(tab="TLS")
    @Summary(value="Its presence will imply the use of SSLServerSocket instead of plain TCP")
    private TlsContextFactory tlsContext;
    @ParameterGroup(name="Connection")
    private SocketConnectionSettings connectionSettings;
    @ParameterGroup(name="Advanced")
    private TcpServerSocketProperties tcpServerSocketProperties;
    @Parameter
    @Optional
    @Summary(value="TCP Protocol to use to receive external request")
    @NullSafe(defaultImplementingType=SafeProtocol.class)
    private TcpProtocol protocol;

    public TcpListenerConnection connect() throws ConnectionException {
        SimpleServerSocketFactory serverSocketFactory = null;
        try {
            serverSocketFactory = this.tlsContext != null ? new SslServerSocketFactory(this.tlsContext) : new TcpServerSocketFactory();
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        TcpListenerConnection connection = new TcpListenerConnection(this.connectionSettings, this.protocol, this.tcpServerSocketProperties, serverSocketFactory);
        connection.connect();
        return connection;
    }

    public void disconnect(TcpListenerConnection connection) {
        connection.disconnect();
    }

    public ConnectionValidationResult validate(TcpListenerConnection connection) {
        return SocketUtils.validate(connection);
    }

    public void initialise() throws InitialisationException {
        if (this.tlsContext != null && !this.tlsContext.isKeyStoreConfigured()) {
            throw new InitialisationException(CoreMessages.createStaticMessage((String)"KeyStore must be configured for server side SSL"), (Initialisable)this);
        }
        LifecycleUtils.initialiseIfNeeded((Object)this.tlsContext);
    }
}

