/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api.socket.factory;

import java.io.IOException;
import java.net.ServerSocket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.mule.extension.socket.api.socket.factory.SimpleServerSocketFactory;
import org.mule.runtime.api.tls.TlsContextFactory;

public class SslServerSocketFactory
implements SimpleServerSocketFactory {
    private final TlsContextFactory tlsContextFactory;
    private final SSLServerSocketFactory sslServerSocketFactory;

    public SslServerSocketFactory(TlsContextFactory tlsContextFactory) throws NoSuchAlgorithmException, KeyManagementException {
        this.tlsContextFactory = tlsContextFactory;
        this.sslServerSocketFactory = tlsContextFactory.createServerSocketFactory();
    }

    @Override
    public ServerSocket createServerSocket() throws IOException {
        SSLServerSocket sslServerSocket = (SSLServerSocket)this.sslServerSocketFactory.createServerSocket();
        sslServerSocket.setNeedClientAuth(this.tlsContextFactory.isTrustStoreConfigured());
        return sslServerSocket;
    }
}

