/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.socket.api.socket.tcp;

import java.util.Objects;
import org.mule.extension.socket.api.socket.tcp.AbstractTcpSocketProperties;
import org.mule.runtime.extension.api.annotation.dsl.xml.TypeDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@TypeDsl(allowTopLevelDefinition=true)
public class TcpServerSocketProperties
extends AbstractTcpSocketProperties {
    @Parameter
    @Optional
    @Placement(tab="Timeout Configuration")
    @Summary(value="Sets the 'SO_TIMEOUT' value when the socket is used as a server")
    private Integer serverTimeout;
    @Parameter
    @Optional(defaultValue="50")
    @Placement(tab="Advanced")
    @Summary(value="The maximum queue length for incoming connections")
    private int receiveBacklog = 50;

    public int getReceiveBacklog() {
        return this.receiveBacklog;
    }

    public Integer getServerTimeout() {
        return this.serverTimeout;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TcpServerSocketProperties that = (TcpServerSocketProperties)o;
        if (this.receiveBacklog != that.receiveBacklog) {
            return false;
        }
        return Objects.equals(this.serverTimeout, that.serverTimeout);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.serverTimeout != null ? this.serverTimeout.hashCode() : 0);
        result = 31 * result + this.receiveBacklog;
        return result;
    }
}

