/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.OutputStream;
import java.net.URI;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.RequestContext;
import org.mule.VoidMuleEvent;
import org.mule.api.FutureMessageResult;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointNotFoundException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.service.Service;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.endpoint.URIBuilder;
import org.mule.transaction.TransactionCoordination;
import org.mule.transformer.types.DataTypeFactory;

public class DefaultMuleEventContext
implements MuleEventContext {
    protected static final Log logger = LogFactory.getLog(DefaultMuleEventContext.class);
    private final MuleEvent event;
    private final MuleSession session;
    private final MuleContext muleContext;
    private final LocalMuleClient clientInterface;

    public DefaultMuleEventContext(MuleEvent event) {
        this.event = event;
        this.session = event.getSession();
        this.muleContext = event.getMuleContext();
        this.clientInterface = this.muleContext.getClient();
    }

    @Override
    public MuleMessage getMessage() {
        return this.event.getMessage();
    }

    @Override
    public byte[] getMessageAsBytes() throws MuleException {
        return this.event.getMessageAsBytes();
    }

    @Override
    public Object transformMessage(DataType dataType) throws TransformerException {
        return this.event.transformMessage(dataType);
    }

    @Override
    public Object transformMessage(Class expectedType) throws TransformerException {
        return this.event.transformMessage(DataTypeFactory.create(expectedType));
    }

    @Override
    @Deprecated
    public byte[] transformMessageToBytes() throws TransformerException {
        return this.event.transformMessage(DataType.BYTE_ARRAY_DATA_TYPE);
    }

    @Override
    public String getMessageAsString(String encoding) throws MuleException {
        return this.event.getMessageAsString(encoding);
    }

    @Override
    public String transformMessageToString() throws TransformerException {
        return this.event.transformMessageToString();
    }

    @Override
    public String getMessageAsString() throws MuleException {
        return this.event.getMessageAsString();
    }

    @Override
    public Transaction getCurrentTransaction() {
        return TransactionCoordination.getInstance().getTransaction();
    }

    @Override
    public void markTransactionForRollback() throws TransactionException {
        if (this.getCurrentTransaction() != null) {
            this.getCurrentTransaction().setRollbackOnly();
        }
    }

    @Override
    public MuleMessage sendEvent(Object message) throws MuleException {
        return this.sendEvent(new DefaultMuleMessage(message, this.event.getMessage(), this.event.getMuleContext()));
    }

    @Override
    public MuleMessage sendEvent(MuleMessage message, OutboundEndpoint endpoint) throws MuleException {
        return this.clientInterface.process(endpoint, message);
    }

    @Override
    public MuleMessage sendEvent(MuleMessage message) throws MuleException {
        if (this.event.getFlowConstruct() instanceof Service) {
            DefaultMuleEvent eventToSend;
            Service service = (Service)this.event.getFlowConstruct();
            MuleEvent event = service.sendEvent(eventToSend = new DefaultMuleEvent(message, MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)service, this.session));
            return event == null || VoidMuleEvent.getInstance().equals(event) ? null : event.getMessage();
        }
        throw new MessagingException(CoreMessages.createStaticMessage("FlowConstuct is not a 'Service', MuleEventContext cannot send this message"), this.event);
    }

    @Override
    public MuleMessage sendEvent(MuleMessage message, EndpointURI endpointUri) throws MuleException {
        EndpointBuilder builder = null;
        if (endpointUri.getEndpointName() != null) {
            builder = this.muleContext.getRegistry().lookupEndpointBuilder(endpointUri.getEndpointName());
        }
        if (builder == null) {
            builder = new EndpointURIEndpointBuilder(new URIBuilder(endpointUri));
        }
        builder.setExchangePattern(MessageExchangePattern.REQUEST_RESPONSE);
        OutboundEndpoint endpoint = this.getMuleContext().getEndpointFactory().getOutboundEndpoint(builder);
        return this.clientInterface.process(endpoint, message);
    }

    @Override
    public FutureMessageResult sendEventAsync(final Object message, final int timeout) throws MuleException {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                DefaultMuleMessage muleMessage = new DefaultMuleMessage(message, DefaultMuleEventContext.this.event.getMessage(), DefaultMuleEventContext.this.event.getMuleContext());
                muleMessage.setOutboundProperty("MULE_EVENT_TIMEOUT", timeout);
                return DefaultMuleEventContext.this.sendEvent(muleMessage);
            }
        };
        FutureMessageResult result = new FutureMessageResult(callable, this.event.getMuleContext());
        result.execute();
        return result;
    }

    @Override
    public FutureMessageResult sendEventAsync(final MuleMessage message, final int timeout) throws MuleException {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                message.setOutboundProperty("MULE_EVENT_TIMEOUT", timeout);
                return DefaultMuleEventContext.this.sendEvent(message);
            }
        };
        FutureMessageResult result = new FutureMessageResult(callable, this.event.getMuleContext());
        result.execute();
        return result;
    }

    @Override
    public FutureMessageResult sendEventAsync(final MuleMessage message, final EndpointURI endpointUri, final int timeout) throws MuleException {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                message.setOutboundProperty("MULE_EVENT_TIMEOUT", timeout);
                return DefaultMuleEventContext.this.sendEvent(message, endpointUri);
            }
        };
        FutureMessageResult result = new FutureMessageResult(callable, this.event.getMuleContext());
        result.execute();
        return result;
    }

    @Override
    public FutureMessageResult sendEventAsync(final MuleMessage message, final String endpointName, final int timeout) throws MuleException {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                message.setOutboundProperty("MULE_EVENT_TIMEOUT", timeout);
                return DefaultMuleEventContext.this.sendEvent(message, endpointName);
            }
        };
        FutureMessageResult result = new FutureMessageResult(callable, this.event.getMuleContext());
        result.execute();
        return result;
    }

    @Override
    public MuleMessage sendEvent(MuleMessage message, String endpointName) throws MuleException {
        return this.clientInterface.send(endpointName, message);
    }

    @Override
    public void dispatchEvent(Object message) throws MuleException {
        this.dispatchEvent(new DefaultMuleMessage(message, this.muleContext));
    }

    @Override
    public void dispatchEvent(MuleMessage message) throws MuleException {
        FlowConstruct flowConstruct = this.event.getFlowConstruct();
        if (flowConstruct == null) {
            throw new IllegalStateException(CoreMessages.objectIsNull("flowConstruct").getMessage());
        }
        if (!(flowConstruct instanceof Service)) {
            throw new UnsupportedOperationException("EventContext.dispatchEvent is only supported when flow constuct is a Service");
        }
        MessageProcessor processor = ((Service)flowConstruct).getOutboundMessageProcessor();
        if (processor == null) {
            throw new EndpointNotFoundException(CoreMessages.noOutboundRouterSetOn(flowConstruct.getName()));
        }
        processor.process(new DefaultMuleEvent(message, RequestContext.getEvent()));
    }

    @Override
    public void dispatchEvent(MuleMessage message, EndpointURI endpointUri) throws MuleException {
        EndpointBuilder builder = null;
        if (endpointUri.getEndpointName() != null) {
            builder = this.muleContext.getRegistry().lookupEndpointBuilder(endpointUri.getEndpointName());
        }
        if (builder == null) {
            builder = new EndpointURIEndpointBuilder(new URIBuilder(endpointUri));
        }
        builder.setExchangePattern(MessageExchangePattern.ONE_WAY);
        OutboundEndpoint endpoint = this.getMuleContext().getEndpointFactory().getOutboundEndpoint(builder);
        this.clientInterface.process(endpoint, message);
    }

    @Override
    public void dispatchEvent(MuleMessage message, String endpointName) throws MuleException {
        EndpointBuilder builder = this.muleContext.getRegistry().lookupEndpointBuilder(endpointName);
        if (builder == null) {
            builder = new EndpointURIEndpointBuilder(new URIBuilder(endpointName, this.muleContext));
        }
        builder.setExchangePattern(MessageExchangePattern.ONE_WAY);
        OutboundEndpoint endpoint = this.getMuleContext().getEndpointFactory().getOutboundEndpoint(builder);
        this.clientInterface.process(endpoint, message);
    }

    @Override
    public void dispatchEvent(MuleMessage message, OutboundEndpoint endpoint) throws MuleException {
        this.clientInterface.process(endpoint, message);
    }

    @Override
    public MuleMessage requestEvent(InboundEndpoint endpoint, long timeout) throws MuleException {
        return this.clientInterface.request(endpoint, timeout);
    }

    @Override
    public MuleMessage requestEvent(String endpointName, long timeout) throws MuleException {
        return this.clientInterface.request(endpointName, timeout);
    }

    @Override
    public MuleMessage requestEvent(EndpointURI endpointUri, long timeout) throws MuleException {
        InboundEndpoint endpoint = this.getMuleContext().getEndpointFactory().getInboundEndpoint(endpointUri);
        return this.requestEvent(endpoint, timeout);
    }

    @Override
    public FlowConstruct getFlowConstruct() {
        return this.event.getFlowConstruct();
    }

    @Override
    public boolean isStopFurtherProcessing() {
        return RequestContext.getEvent().isStopFurtherProcessing();
    }

    @Override
    public void setStopFurtherProcessing(boolean stopFurtherProcessing) {
        this.event.setStopFurtherProcessing(stopFurtherProcessing);
    }

    @Override
    public OutputStream getOutputStream() {
        return this.event.getOutputStream();
    }

    @Override
    public URI getEndpointURI() {
        return this.event.getMessageSourceURI();
    }

    @Override
    public MessageExchangePattern getExchangePattern() {
        return this.event.getExchangePattern();
    }

    @Override
    public Transaction getTransaction() {
        return TransactionCoordination.getInstance().getTransaction();
    }

    @Override
    public int getTimeout() {
        return this.event.getTimeout();
    }

    @Override
    public String getEncoding() {
        return this.event.getEncoding();
    }

    @Override
    public MuleSession getSession() {
        return this.event.getSession();
    }

    public String toString() {
        return this.event.toString();
    }

    @Override
    public MuleContext getMuleContext() {
        return this.event.getMuleContext();
    }
}

