/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.bootstrap;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.registry.ObjectProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.Registry;
import org.mule.api.registry.TransformerResolver;
import org.mule.api.transaction.TransactionFactory;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.Transformer;
import org.mule.api.util.StreamCloser;
import org.mule.config.bootstrap.BootstrapException;
import org.mule.config.bootstrap.BootstrapObjectFactory;
import org.mule.config.bootstrap.ClassPathRegistryBootstrapDiscoverer;
import org.mule.config.bootstrap.RegistryBootstrapDiscoverer;
import org.mule.config.i18n.CoreMessages;
import org.mule.registry.MuleRegistryHelper;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.ClassUtils;
import org.mule.util.ExceptionUtils;
import org.mule.util.OrderedProperties;
import org.mule.util.PropertiesUtils;
import org.mule.util.UUID;

public class SimpleRegistryBootstrap
implements Initialisable,
MuleContextAware {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    public String TRANSFORMER_KEY = ".transformer.";
    public String OBJECT_KEY = ".object.";
    public String SINGLE_TX = ".singletx.";
    private ArtifactType supportedArtifactType = ArtifactType.APP;
    private final RegistryBootstrapDiscoverer discoverer;
    protected MuleContext context;

    public SimpleRegistryBootstrap() {
        this(new ClassPathRegistryBootstrapDiscoverer());
    }

    public SimpleRegistryBootstrap(RegistryBootstrapDiscoverer discoverer) {
        this.discoverer = discoverer;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.context = context;
    }

    @Override
    public void initialise() throws InitialisationException {
        List<Properties> bootstraps;
        try {
            bootstraps = this.discoverer.discover();
        }
        catch (BootstrapException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        int objectCounter = 1;
        int transformerCounter = 1;
        OrderedProperties transformers = new OrderedProperties();
        OrderedProperties namedObjects = new OrderedProperties();
        OrderedProperties unnamedObjects = new OrderedProperties();
        LinkedHashMap<String, String> singleTransactionFactories = new LinkedHashMap<String, String>();
        for (Properties bootstrap : bootstraps) {
            for (Map.Entry<Object, Object> entry : bootstrap.entrySet()) {
                String newKey;
                String key = (String)entry.getKey();
                if (key.contains(this.OBJECT_KEY)) {
                    newKey = key.substring(0, key.lastIndexOf(".")) + objectCounter++;
                    ((Properties)unnamedObjects).put(newKey, entry.getValue());
                    continue;
                }
                if (key.contains(this.TRANSFORMER_KEY)) {
                    newKey = key.substring(0, key.lastIndexOf(".")) + transformerCounter++;
                    ((Properties)transformers).put(newKey, entry.getValue());
                    continue;
                }
                if (key.contains(this.SINGLE_TX)) {
                    if (key.contains(".transaction.resource")) continue;
                    String transactionResourceKey = key.replace(".transaction.factory", ".transaction.resource");
                    String transactionResource = bootstrap.getProperty(transactionResourceKey);
                    if (transactionResource == null) {
                        throw new InitialisationException(CoreMessages.createStaticMessage(String.format("Theres no transaction resource specified for transaction factory %s", key)), (Initialisable)this);
                    }
                    singleTransactionFactories.put((String)entry.getValue(), transactionResource);
                    continue;
                }
                ((Properties)namedObjects).put(key, entry.getValue());
            }
        }
        try {
            this.registerUnnamedObjects(unnamedObjects, this.context.getRegistry());
            this.registerTransformers((MuleRegistryHelper)this.context.getRegistry());
            this.registerTransformers(transformers, this.context.getRegistry());
            this.registerObjects(namedObjects, this.context.getRegistry());
            this.registerTransactionFactories(singleTransactionFactories, this.context);
        }
        catch (Exception e1) {
            throw new InitialisationException((Throwable)e1, (Initialisable)this);
        }
    }

    private void registerTransactionFactories(Map<String, String> singleTransactionFactories, MuleContext context) throws Exception {
        for (Map.Entry<String, String> entry : singleTransactionFactories.entrySet()) {
            String transactionResourceClassNameProperties = entry.getValue();
            String transactionFactoryClassName = entry.getKey();
            boolean optional = false;
            int x = transactionResourceClassNameProperties.indexOf(",");
            if (x > -1) {
                Properties p = PropertiesUtils.getPropertiesFromString(transactionResourceClassNameProperties.substring(x + 1), ',');
                optional = p.containsKey("optional");
            }
            String transactionResourceClassName = x == -1 ? transactionResourceClassNameProperties : transactionResourceClassNameProperties.substring(0, x);
            try {
                context.getTransactionFactoryManager().registerTransactionFactory(Class.forName(transactionResourceClassName), (TransactionFactory)Class.forName(transactionFactoryClassName).newInstance());
            }
            catch (NoClassDefFoundError ncdfe) {
                this.throwExceptionIfNotOptional(optional, ncdfe, "Ignoring optional transaction factory: " + transactionResourceClassName);
            }
            catch (ClassNotFoundException cnfe) {
                this.throwExceptionIfNotOptional(optional, cnfe, "Ignoring optional transaction factory: " + transactionResourceClassName);
            }
        }
    }

    private void registerTransformers(Properties props, MuleRegistry registry) throws Exception {
        String name = null;
        boolean optional = false;
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String transString = (String)entry.getValue();
            Class returnClass = null;
            String returnClassString = null;
            int x = transString.indexOf(",");
            if (x > -1) {
                Properties p = PropertiesUtils.getPropertiesFromString(transString.substring(x + 1), ',');
                name = p.getProperty("name", null);
                returnClassString = p.getProperty("returnClass", null);
                optional = p.containsKey("optional");
            }
            String transClass = x == -1 ? transString : transString.substring(0, x);
            try {
                Transformer trans;
                String mime = null;
                if (returnClassString != null) {
                    int i = returnClassString.indexOf(":");
                    if (i > -1) {
                        mime = returnClassString.substring(i + 1);
                        returnClassString = returnClassString.substring(0, i);
                    }
                    returnClass = returnClassString.equals("byte[]") ? byte[].class : ClassUtils.loadClass(returnClassString, this.getClass());
                }
                if (!((trans = (Transformer)ClassUtils.instanciateClass(transClass, new Object[0])) instanceof DiscoverableTransformer)) {
                    throw new RegistrationException(CoreMessages.transformerNotImplementDiscoverable(trans));
                }
                if (returnClass != null) {
                    trans.setReturnDataType(DataTypeFactory.create(returnClass, mime));
                }
                if (name != null) {
                    trans.setName(name);
                } else {
                    name = trans.getName();
                    trans.setName("_" + name);
                }
                registry.registerTransformer(trans);
            }
            catch (InvocationTargetException itex) {
                Throwable cause = ExceptionUtils.getCause((Throwable)itex);
                this.throwExceptionIfNotOptional(cause instanceof NoClassDefFoundError && optional, cause, "Ignoring optional transformer: " + transClass);
            }
            catch (NoClassDefFoundError ncdfe) {
                this.throwExceptionIfNotOptional(optional, ncdfe, "Ignoring optional transformer: " + transClass);
            }
            catch (ClassNotFoundException cnfe) {
                this.throwExceptionIfNotOptional(optional, cnfe, "Ignoring optional transformer: " + transClass);
            }
            name = null;
            returnClass = null;
        }
    }

    private void registerTransformers(MuleRegistryHelper registry) throws MuleException {
        Map<String, Converter> converters = registry.lookupByType(Converter.class);
        for (Converter converter : converters.values()) {
            registry.notifyTransformerResolvers(converter, TransformerResolver.RegistryAction.ADDED);
        }
    }

    private void registerObjects(Properties props, Registry registry) throws Exception {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            this.registerObject((String)entry.getKey(), (String)entry.getValue(), registry);
        }
        props.clear();
    }

    private void registerUnnamedObjects(Properties props, Registry registry) throws Exception {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = String.format("%s#%s", entry.getKey(), UUID.getUUID());
            this.registerObject(key, (String)entry.getValue(), registry);
        }
        props.clear();
    }

    private void registerObject(String key, String value, Registry registry) throws Exception {
        ArtifactType artifactTypeParameterValue = ArtifactType.APP;
        boolean optional = false;
        String className = null;
        try {
            int x = value.indexOf(",");
            if (x > -1) {
                Properties p = PropertiesUtils.getPropertiesFromString(value.substring(x + 1), ',');
                if (p.containsKey("applyToArtifactType")) {
                    artifactTypeParameterValue = ArtifactType.createFromString((String)p.get("applyToArtifactType"));
                }
                optional = p.containsKey("optional");
                className = value.substring(0, x);
            } else {
                className = value;
            }
            if (!artifactTypeParameterValue.equals((Object)ArtifactType.ALL) && !artifactTypeParameterValue.equals((Object)this.supportedArtifactType)) {
                return;
            }
            Object o = ClassUtils.instanciateClass(className, new Object[0]);
            Class<Object> meta = Object.class;
            if (o instanceof ObjectProcessor) {
                meta = ObjectProcessor.class;
            } else if (o instanceof StreamCloser) {
                meta = StreamCloser.class;
            } else if (o instanceof BootstrapObjectFactory) {
                o = ((BootstrapObjectFactory)o).create();
            }
            registry.registerObject(key, o, meta);
        }
        catch (InvocationTargetException itex) {
            Throwable cause = ExceptionUtils.getCause((Throwable)itex);
            this.throwExceptionIfNotOptional(cause instanceof NoClassDefFoundError && optional, cause, "Ignoring optional object: " + className);
        }
        catch (NoClassDefFoundError ncdfe) {
            this.throwExceptionIfNotOptional(optional, ncdfe, "Ignoring optional object: " + className);
        }
        catch (ClassNotFoundException cnfe) {
            this.throwExceptionIfNotOptional(optional, cnfe, "Ignoring optional object: " + className);
        }
    }

    private void throwExceptionIfNotOptional(boolean optional, Throwable t, String message) throws Exception {
        if (optional) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)message);
            }
        } else {
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new Exception(t);
        }
    }

    public void setSupportedArtifactType(ArtifactType supportedArtifactType) {
        this.supportedArtifactType = supportedArtifactType;
    }

    public static enum ArtifactType {
        APP("app"),
        DOMAIN("domain"),
        ALL("app/domain");

        public static final String APPLY_TO_ARTIFACT_TYPE_PARAMETER_KEY = "applyToArtifactType";
        private final String artifactTypeAsString;

        private ArtifactType(String artifactTypeAsString) {
            this.artifactTypeAsString = artifactTypeAsString;
        }

        public String getAsString() {
            return this.artifactTypeAsString;
        }

        public static ArtifactType createFromString(String artifactTypeAsString) {
            for (ArtifactType artifactType : ArtifactType.values()) {
                if (!artifactType.artifactTypeAsString.equals(artifactTypeAsString)) continue;
                return artifactType;
            }
            throw new MuleRuntimeException(CoreMessages.createStaticMessage("No artifact type found for value: " + artifactTypeAsString));
        }
    }
}

