/*
 * Decompiled with CFR 0.152.
 */
package org.mule.execution;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.execution.ExecutionCallback;
import org.mule.execution.AsyncResponseFlowProcessingPhaseTemplate;
import org.mule.execution.MessageProcessContext;
import org.mule.execution.MessageProcessPhase;
import org.mule.execution.MessageProcessTemplate;
import org.mule.execution.PhaseResultNotifier;
import org.mule.execution.ResponseCompletionCallback;
import org.mule.execution.TransactionalErrorHandlingExecutionTemplate;
import org.mule.execution.ValidationPhase;
import org.mule.transaction.MuleTransactionConfig;

public class AsyncResponseFlowProcessingPhase
implements MessageProcessPhase<AsyncResponseFlowProcessingPhaseTemplate>,
Comparable<MessageProcessPhase> {
    protected transient Log logger = LogFactory.getLog(this.getClass());

    @Override
    public boolean supportsTemplate(MessageProcessTemplate messageProcessTemplate) {
        return messageProcessTemplate instanceof AsyncResponseFlowProcessingPhaseTemplate;
    }

    @Override
    public void runPhase(final AsyncResponseFlowProcessingPhaseTemplate template, MessageProcessContext messageProcessContext, PhaseResultNotifier phaseResultNotifier) {
        try {
            try {
                MessagingExceptionHandler exceptionHandler = messageProcessContext.getFlowConstruct().getExceptionListener();
                TransactionalErrorHandlingExecutionTemplate transactionTemplate = TransactionalErrorHandlingExecutionTemplate.createMainExecutionTemplate(messageProcessContext.getFlowConstruct().getMuleContext(), messageProcessContext.getTransactionConfig() == null ? new MuleTransactionConfig() : messageProcessContext.getTransactionConfig(), exceptionHandler);
                Object response = transactionTemplate.execute((ExecutionCallback)new ExecutionCallback<MuleEvent>(){

                    @Override
                    public MuleEvent process() throws Exception {
                        MuleEvent muleEvent = template.getMuleEvent();
                        muleEvent = template.routeEvent(muleEvent);
                        return muleEvent;
                    }
                });
                template.sendResponseToClient((MuleEvent)response, this.createResponseCompletationCallback(phaseResultNotifier, exceptionHandler));
            }
            catch (MessagingException e) {
                template.sendFailureResponseToClient(e, this.createSendFailureResponseCompletationCallback(phaseResultNotifier));
            }
        }
        catch (Exception e) {
            phaseResultNotifier.phaseFailure(e);
        }
    }

    private ResponseCompletionCallback createSendFailureResponseCompletationCallback(final PhaseResultNotifier phaseResultNotifier) {
        return new ResponseCompletionCallback(){

            @Override
            public void responseSentSuccessfully() {
                phaseResultNotifier.phaseSuccessfully();
            }

            @Override
            public void responseSentWithFailure(Exception e, MuleEvent event) {
                phaseResultNotifier.phaseFailure(e);
            }
        };
    }

    private ResponseCompletionCallback createResponseCompletationCallback(final PhaseResultNotifier phaseResultNotifier, final MessagingExceptionHandler exceptionListener) {
        return new ResponseCompletionCallback(){

            @Override
            public void responseSentSuccessfully() {
                phaseResultNotifier.phaseSuccessfully();
            }

            @Override
            public void responseSentWithFailure(final Exception e, final MuleEvent event) {
                AsyncResponseFlowProcessingPhase.this.executeCallback(new Callback(){

                    @Override
                    public void execute() throws Exception {
                        exceptionListener.handleException(e, event);
                        phaseResultNotifier.phaseSuccessfully();
                    }
                }, phaseResultNotifier);
            }
        };
    }

    private void executeCallback(Callback callback, PhaseResultNotifier phaseResultNotifier) {
        try {
            callback.execute();
        }
        catch (Exception callbackException) {
            phaseResultNotifier.phaseFailure(callbackException);
        }
    }

    @Override
    public int compareTo(MessageProcessPhase messageProcessPhase) {
        if (messageProcessPhase instanceof ValidationPhase) {
            return 1;
        }
        return 0;
    }

    private static interface Callback {
        public void execute() throws Exception;
    }
}

