/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.mule.VoidMuleEvent;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.config.i18n.MessageFactory;
import org.mule.routing.UntilSuccessfulConfiguration;
import org.mule.routing.UntilSuccessfulProcessingStrategy;

public abstract class AbstractUntilSuccessfulProcessingStrategy
implements UntilSuccessfulProcessingStrategy {
    private UntilSuccessfulConfiguration untilSuccessfulConfiguration;

    @Override
    public void setUntilSuccessfulConfiguration(UntilSuccessfulConfiguration untilSuccessfulConfiguration) {
        this.untilSuccessfulConfiguration = untilSuccessfulConfiguration;
    }

    protected MuleEvent processEvent(MuleEvent event) {
        MuleEvent returnEvent;
        try {
            returnEvent = this.untilSuccessfulConfiguration.getRoute().process(event);
        }
        catch (MuleException me) {
            throw new MuleRuntimeException(me);
        }
        if (returnEvent == null || VoidMuleEvent.getInstance().equals(returnEvent)) {
            return returnEvent;
        }
        MuleMessage msg = returnEvent.getMessage();
        if (msg == null) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage("No message found in response to processing, which is therefore considered failed for event: " + event));
        }
        boolean errorDetected = this.untilSuccessfulConfiguration.getFailureExpressionFilter().accept(msg);
        if (errorDetected) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage("Failure expression positive when processing event: " + event));
        }
        return returnEvent;
    }

    protected MuleEvent processResponseThroughAckResponseExpression(MuleEvent event) {
        if (event == null || VoidMuleEvent.getInstance().equals(event)) {
            return VoidMuleEvent.getInstance();
        }
        if (this.untilSuccessfulConfiguration.getAckExpression() == null) {
            return event;
        }
        event.getMessage().setPayload(this.getUntilSuccessfulConfiguration().getMuleContext().getExpressionManager().evaluate(this.getUntilSuccessfulConfiguration().getAckExpression(), event));
        return event;
    }

    protected UntilSuccessfulConfiguration getUntilSuccessfulConfiguration() {
        return this.untilSuccessfulConfiguration;
    }
}

