/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class EventProcessingThread
extends Thread {
    protected final Log logger = LogFactory.getLog(EventProcessingThread.class);
    protected volatile boolean stopRequested;
    protected long delayTime;
    protected Object lock = new Object();

    public EventProcessingThread(String name, long delayTime) {
        this.setName(name);
        this.delayTime = delayTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNow() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public void stopProcessing() {
        this.logger.debug((Object)("Stopping " + this.getName()));
        this.stopRequested = true;
        this.processNow();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean delay(long timeToDelay) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.lock.wait(timeToDelay);
            }
        }
        catch (InterruptedException e) {
            return true;
        }
        return false;
    }

    @Override
    public final void run() {
        do {
            if (this.stopRequested) {
                this.logger.debug((Object)"Received request to stop processing events");
                break;
            }
            try {
                this.doRun();
            }
            catch (RuntimeException e) {
                this.logger.warn((Object)String.format("Caught exception on event processing thread '%s'", this.getName()), (Throwable)e);
            }
        } while (!this.delay(this.delayTime));
        this.logger.debug((Object)(this.getName() + " fully stopped"));
    }

    protected abstract void doRun();
}

