/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.encryption;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.mule.api.EncryptionStrategy;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.CryptoFailureException;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;

public abstract class AbstractEncryptionTransformer
extends AbstractTransformer {
    private EncryptionStrategy strategy = null;
    private String strategyName = null;

    public AbstractEncryptionTransformer() {
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.registerSourceType(DataTypeFactory.STRING);
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
        this.setReturnDataType(DataTypeFactory.INPUT_STREAM);
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractEncryptionTransformer clone = (AbstractEncryptionTransformer)super.clone();
        clone.setStrategy(this.strategy);
        clone.setStrategyName(this.strategyName);
        return clone;
    }

    @Override
    public Object doTransform(Object src, String outputEncoding) throws TransformerException {
        InputStream input = src instanceof String ? new ByteArrayInputStream(src.toString().getBytes()) : (src instanceof InputStream ? (InputStream)src : new ByteArrayInputStream((byte[])src));
        try {
            return this.primTransform(input);
        }
        catch (CryptoFailureException e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }

    protected abstract InputStream primTransform(InputStream var1) throws CryptoFailureException;

    @Override
    public void initialise() throws InitialisationException {
        if (this.strategyName != null) {
            if (this.endpoint.getMuleContext().getSecurityManager() == null) {
                if (this.strategy == null) {
                    throw new InitialisationException(CoreMessages.authSecurityManagerNotSet(), (Initialisable)this);
                }
            } else {
                this.strategy = this.endpoint.getMuleContext().getSecurityManager().getEncryptionStrategy(this.strategyName);
            }
        }
        if (this.strategy == null) {
            throw new InitialisationException(CoreMessages.encryptionStrategyNotSet(), (Initialisable)this);
        }
    }

    public EncryptionStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(EncryptionStrategy strategy) {
        this.strategy = strategy;
    }

    public String getStrategyName() {
        return this.strategyName;
    }

    public void setStrategyName(String strategyName) {
        this.strategyName = strategyName;
    }
}

