/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.regex.Pattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.expression.ExpressionManager;
import org.mule.config.i18n.CoreMessages;

public class AttributeEvaluator {
    private static final Pattern SINGLE_EXPRESSION_REGEX_PATTERN = Pattern.compile("^#\\[(?:(?!#\\[).)*\\]$");
    private final String attributeValue;
    private ExpressionManager expressionManager;
    private AttributeType attributeType;

    public AttributeEvaluator(String attributeValue) {
        this.attributeValue = attributeValue;
    }

    public AttributeEvaluator initialize(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
        this.resolveAttributeType();
        return this;
    }

    private void resolveAttributeType() {
        this.attributeType = this.attributeValue != null && SINGLE_EXPRESSION_REGEX_PATTERN.matcher(this.attributeValue).matches() ? AttributeType.EXPRESSION : (this.attributeValue != null && this.isParseExpression(this.attributeValue) ? AttributeType.PARSE_EXPRESSION : AttributeType.STATIC_VALUE);
    }

    private boolean isParseExpression(String attributeValue) {
        int beginExpression = attributeValue.indexOf("#[");
        if (beginExpression == -1) {
            return false;
        }
        String remainingString = attributeValue.substring(beginExpression + "#[".length());
        return remainingString.contains("]");
    }

    public boolean isExpression() {
        return this.attributeType.equals((Object)AttributeType.EXPRESSION);
    }

    public boolean isParseExpression() {
        return this.attributeType.equals((Object)AttributeType.PARSE_EXPRESSION);
    }

    public Object resolveValue(MuleMessage message) {
        if (this.isExpression()) {
            return this.expressionManager.evaluate(this.attributeValue, message);
        }
        if (this.isParseExpression()) {
            return this.expressionManager.parse(this.attributeValue, message);
        }
        return this.attributeValue;
    }

    public Object resolveValue(MuleEvent event) {
        if (this.isExpression()) {
            return this.expressionManager.evaluate(this.attributeValue, event);
        }
        if (this.isParseExpression()) {
            return this.expressionManager.parse(this.attributeValue, event);
        }
        return this.attributeValue;
    }

    public Integer resolveIntegerValue(MuleEvent event) {
        Object value = this.resolveValue(event);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new MuleRuntimeException(CoreMessages.createStaticMessage(String.format("Value was required as integer but is of type: %s", value.getClass().getName())));
    }

    public String resolveStringValue(MuleEvent event) {
        Object value = this.resolveValue(event);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public Boolean resolveBooleanValue(MuleEvent event) {
        Object value = this.resolveValue(event);
        if (value == null || value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.valueOf(value.toString());
    }

    public String getRawValue() {
        return this.attributeValue;
    }

    private static enum AttributeType {
        EXPRESSION,
        PARSE_EXPRESSION,
        STATIC_VALUE;

    }
}

