/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import org.slf4j.Logger;

public class OneTimeWarning {
    private final Logger logger;
    private final String message;
    private boolean warned = false;
    private Delegate delegate = new FirstTimeDelegate();

    public OneTimeWarning(Logger logger, String message) {
        this.logger = logger;
        this.message = message;
    }

    public void warn() {
        this.delegate.warn();
    }

    private class NoOpDelegate
    implements Delegate {
        private NoOpDelegate() {
        }

        @Override
        public void warn() {
        }
    }

    private class FirstTimeDelegate
    implements Delegate {
        private FirstTimeDelegate() {
        }

        @Override
        public synchronized void warn() {
            if (!OneTimeWarning.this.warned) {
                OneTimeWarning.this.logger.warn(OneTimeWarning.this.message);
                OneTimeWarning.this.warned = true;
                OneTimeWarning.this.delegate = new NoOpDelegate();
            }
        }
    }

    private static interface Delegate {
        public void warn();
    }
}

