/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.api.MuleRuntimeException;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectStoreException;

public class ObjectStoreToMapAdapter<ValueType extends Serializable>
implements Map<Serializable, ValueType> {
    private final ListableObjectStore<ValueType> objectStore;

    public ObjectStoreToMapAdapter(ListableObjectStore<ValueType> listableObjectStore) {
        this.objectStore = listableObjectStore;
    }

    @Override
    public int size() {
        try {
            return this.objectStore.allKeys().size();
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            return this.objectStore.allKeys().isEmpty();
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            return this.objectStore.contains((Serializable)key);
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Map adapter for object store does not support contains value");
    }

    @Override
    public ValueType get(Object key) {
        try {
            if (!this.objectStore.contains((Serializable)key)) {
                return null;
            }
            return (ValueType)this.objectStore.retrieve((Serializable)key);
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public ValueType put(Serializable key, ValueType value) {
        ValueType previousValue = null;
        try {
            if (this.objectStore.contains(key)) {
                previousValue = (ValueType)this.objectStore.retrieve(key);
                this.objectStore.remove(key);
            }
            if (value != null) {
                this.objectStore.store(key, value);
            }
            return previousValue;
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public ValueType remove(Object key) {
        try {
            if (this.objectStore.contains((Serializable)key)) {
                return (ValueType)this.objectStore.remove((Serializable)key);
            }
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Serializable, ? extends ValueType> mapToAdd) {
        for (Serializable serializable : mapToAdd.keySet()) {
            this.put(serializable, (ValueType)((Serializable)mapToAdd.get(serializable)));
        }
    }

    @Override
    public void clear() {
        try {
            this.objectStore.clear();
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public Set<Serializable> keySet() {
        try {
            List<Serializable> allKeys = this.objectStore.allKeys();
            return new HashSet<Serializable>(allKeys);
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public Collection<ValueType> values() {
        throw new UnsupportedOperationException("ObjectStoreToMapAdapter does not support values() method");
    }

    @Override
    public Set<Map.Entry<Serializable, ValueType>> entrySet() {
        throw new UnsupportedOperationException("ObjectStoreToMapAdapter does not support entrySet() method");
    }
}

