/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.model;

import java.lang.reflect.Method;
import org.mule.api.model.EntryPointResolver;
import org.mule.config.i18n.CoreMessages;

public class InvocationResult {
    @Deprecated
    public static final State STATE_INVOKE_NOT_SUPPORTED = State.NOT_SUPPORTED;
    @Deprecated
    public static final State STATE_INVOKED_SUCESSFUL = State.SUCCESSFUL;
    @Deprecated
    public static final State STATE_INVOKED_FAILED = State.FAILED;
    private String errorMessage;
    private String methodCalled;
    private Object result;
    private State state;
    private EntryPointResolver resolver;

    public InvocationResult(EntryPointResolver resolver, State state) {
        this.state = state;
        this.resolver = resolver;
    }

    public InvocationResult(EntryPointResolver resolver, Object result, Method method) {
        this.result = result;
        this.state = State.SUCCESSFUL;
        this.methodCalled = method.getName();
        this.resolver = resolver;
    }

    public String getMethodCalled() {
        return this.methodCalled;
    }

    public Object getResult() {
        return this.result;
    }

    public State getState() {
        return this.state;
    }

    public void setErrorMessage(String message) {
        if (this.state == State.SUCCESSFUL) {
            throw new IllegalStateException(CoreMessages.invocationSuccessfulCantSetError().toString());
        }
        this.errorMessage = message;
    }

    public boolean hasError() {
        return this.errorMessage != null;
    }

    public String getErrorMessage() {
        return this.errorMessage == null ? null : this.resolver.getClass().getSimpleName() + ": " + this.errorMessage;
    }

    public void setErrorTooManyMatchingMethods(Object component, Class<?>[] argTypes, String methods) {
        this.setErrorMessage(CoreMessages.tooManyAcceptableMethodsOnObjectUsingResolverForTypes(component.getClass().getName(), argTypes, methods).toString());
    }

    public void setErrorNoMatchingMethods(Object component, Class<?>[] args) {
        this.setErrorMessage(CoreMessages.noEntryPointFoundWithArgsUsingResolver(component.getClass().getName(), args).toString());
    }

    public void setErrorNoMatchingMethodsCalled(Object component, String methods) {
        this.setErrorMessage(CoreMessages.noMatchingMethodsOnObjectCalledUsingResolver(component.getClass().getName(), methods).toString());
    }

    public static enum State {
        NOT_SUPPORTED,
        SUCCESSFUL,
        FAILED;

    }
}

