/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.transport;

import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.transport.ReplyToHandler;

public class ExceptionHandlingReplyToHandlerDecorator
implements ReplyToHandler {
    private final MessagingExceptionHandler messagingExceptionHandler;
    private final ReplyToHandler delegate;

    public ExceptionHandlingReplyToHandlerDecorator(ReplyToHandler replyToHandler, MessagingExceptionHandler exceptionHandler) {
        this.delegate = replyToHandler;
        this.messagingExceptionHandler = exceptionHandler;
    }

    @Override
    public void processReplyTo(MuleEvent event, MuleMessage returnMessage, Object replyTo) throws MuleException {
        this.delegate.processReplyTo(event, returnMessage, replyTo);
    }

    @Override
    public void processExceptionReplyTo(MessagingException exception, Object replyTo) {
        MuleEvent result = this.messagingExceptionHandler != null ? this.messagingExceptionHandler.handleException(exception, exception.getEvent()) : exception.getEvent().getFlowConstruct().getExceptionListener().handleException(exception, exception.getEvent());
        exception.setProcessedEvent(result);
        if (!exception.handled()) {
            this.delegate.processExceptionReplyTo(exception, replyTo);
        } else {
            try {
                this.delegate.processReplyTo(exception.getEvent(), exception.getEvent().getMessage(), replyTo);
            }
            catch (MuleException e) {
                this.delegate.processExceptionReplyTo(new MessagingException(exception.getEvent(), (Throwable)e), replyTo);
            }
        }
    }
}

