/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.mvel.datatype;

import java.lang.reflect.Field;
import org.mule.api.MuleMessage;
import org.mule.api.transport.PropertyScope;
import org.mule.el.mvel.datatype.AbstractEnricherDataTypePropagator;
import org.mule.mvel2.ast.ASTNode;
import org.mule.mvel2.ast.AssignmentNode;
import org.mule.mvel2.ast.DeepAssignmentNode;
import org.mule.mvel2.compiler.AccessorNode;
import org.mule.mvel2.compiler.CompiledAccExpression;
import org.mule.mvel2.compiler.ExecutableLiteral;
import org.mule.mvel2.optimizers.impl.refl.nodes.MapAccessor;
import org.mule.mvel2.optimizers.impl.refl.nodes.MapAccessorNest;
import org.mule.mvel2.optimizers.impl.refl.nodes.VariableAccessor;
import org.mule.transformer.types.TypedValue;

public class AbstractVariableEnricherDataTypePropagator
extends AbstractEnricherDataTypePropagator {
    private final String propertyName;
    private final PropertyScope scope;
    private final Field accExprFieldForMapSyntax;
    private final Field accExprFieldForDotSyntax;

    public AbstractVariableEnricherDataTypePropagator(String propertyName, PropertyScope scope) {
        this.propertyName = propertyName;
        this.scope = scope;
        try {
            this.accExprFieldForMapSyntax = AssignmentNode.class.getDeclaredField("accExpr");
            this.accExprFieldForMapSyntax.setAccessible(true);
            this.accExprFieldForDotSyntax = DeepAssignmentNode.class.getDeclaredField("acc");
            this.accExprFieldForDotSyntax.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected boolean doPropagate(MuleMessage message, TypedValue typedValue, ASTNode node) {
        VariableAccessor variableAccessor;
        CompiledAccExpression compiledAccExpression;
        if (this.isAssignmentNode(node) && (compiledAccExpression = this.getCompiledAccExpression(node)).getAccessor() instanceof VariableAccessor && (variableAccessor = (VariableAccessor)compiledAccExpression.getAccessor()).getProperty().equals(this.propertyName)) {
            AccessorNode nextNode = variableAccessor.getNextNode();
            String propertyName = null;
            if (nextNode instanceof MapAccessorNest) {
                MapAccessorNest mapAccesorNest = (MapAccessorNest)nextNode;
                if (mapAccesorNest.getProperty().isLiteralOnly()) {
                    propertyName = (String)((ExecutableLiteral)mapAccesorNest.getProperty()).getLiteral();
                }
            } else if (nextNode instanceof MapAccessor) {
                propertyName = (String)((MapAccessor)nextNode).getProperty();
            }
            if (propertyName != null && message.getPropertyNames(this.scope).contains(propertyName)) {
                propertyName = this.getUnescapedPropertyName(propertyName);
                message.setProperty(propertyName, typedValue.getValue(), this.scope, typedValue.getDataType());
                return true;
            }
        }
        return false;
    }

    private String getUnescapedPropertyName(String propertyName) {
        if (propertyName.startsWith("'") && propertyName.endsWith("'")) {
            propertyName = propertyName.substring(1, propertyName.length() - 1);
        }
        return propertyName;
    }

    private boolean isAssignmentNode(ASTNode node) {
        return node instanceof AssignmentNode && ((AssignmentNode)node).getAssignmentVar().startsWith(this.propertyName) || node instanceof DeepAssignmentNode && ((DeepAssignmentNode)node).getAssignmentVar().startsWith(this.propertyName);
    }

    private CompiledAccExpression getCompiledAccExpression(ASTNode node) {
        try {
            if (node instanceof AssignmentNode) {
                return (CompiledAccExpression)this.accExprFieldForMapSyntax.get(node);
            }
            return (CompiledAccExpression)this.accExprFieldForDotSyntax.get(node);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

