/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.AbstractAnnotatedObject;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.notification.ServerNotificationHandler;
import org.mule.api.processor.InternalMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.api.processor.MessageProcessorContainer;
import org.mule.api.processor.MessageProcessorPathElement;
import org.mule.execution.MessageProcessorExecutionTemplate;
import org.mule.processor.chain.ProcessorExecutorFactory;
import org.mule.util.NotificationUtils;
import org.mule.util.ObjectUtils;

public abstract class AbstractInterceptingMessageProcessorBase
extends AbstractAnnotatedObject
implements MessageProcessor,
MuleContextAware,
MessageProcessorContainer {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected ServerNotificationHandler notificationHandler;
    private MessageProcessorExecutionTemplate messageProcessorExecutorWithoutNotifications = MessageProcessorExecutionTemplate.createExceptionTransformerExecutionTemplate();
    private MessageProcessorExecutionTemplate messageProcessorExecutorWithNotifications = MessageProcessorExecutionTemplate.createExecutionTemplate();
    protected MuleContext muleContext;
    protected MessageProcessor next;

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        this.notificationHandler = this.muleContext.getNotificationManager();
    }

    public final MessageProcessor getListener() {
        return this.next;
    }

    public void setListener(MessageProcessor next) {
        this.next = next;
    }

    protected MuleEvent processNext(MuleEvent event) throws MuleException {
        if (this.next == null) {
            return event;
        }
        if (event == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.trace((Object)("MuleEvent is null.  Next MessageProcessor '" + this.next.getClass().getName() + "' will not be invoked."));
            }
            return null;
        }
        if (VoidMuleEvent.getInstance().equals(event)) {
            return event;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Invoking next MessageProcessor: '" + this.next.getClass().getName() + "' "));
        }
        MessageProcessorExecutionTemplate executionTemplate = !(this.next instanceof MessageProcessorChain) ? this.messageProcessorExecutorWithNotifications : this.messageProcessorExecutorWithoutNotifications;
        try {
            return new ProcessorExecutorFactory().createProcessorExecutor(event, Collections.singletonList(this.next), executionTemplate, false).execute();
        }
        catch (MessagingException e) {
            event.getSession().setValid(false);
            throw e;
        }
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public String toString() {
        return ObjectUtils.toString(this);
    }

    protected boolean isEventValid(MuleEvent event) {
        return event != null && !(event instanceof VoidMuleEvent);
    }

    @Override
    public void addMessageProcessorPathElements(MessageProcessorPathElement pathElement) {
        if (this.next instanceof InternalMessageProcessor) {
            return;
        }
        if (this.next instanceof MessageProcessorChain) {
            NotificationUtils.addMessageProcessorPathElements(((MessageProcessorChain)this.next).getMessageProcessors(), pathElement.getParent());
        } else if (this.next != null) {
            NotificationUtils.addMessageProcessorPathElements(Arrays.asList(this.next), pathElement.getParent());
        }
    }
}

