/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import org.mule.DefaultMuleEvent;
import org.mule.NonBlockingVoidMuleEvent;
import org.mule.OptimizedRequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.NonBlockingSupported;
import org.mule.api.transport.ReplyToHandler;
import org.mule.processor.AbstractInterceptingMessageProcessor;

public abstract class AbstractRequestResponseMessageProcessor
extends AbstractInterceptingMessageProcessor
implements NonBlockingSupported {
    @Override
    public final MuleEvent process(MuleEvent event) throws MuleException {
        if (this.isNonBlocking(event)) {
            return this.processNonBlocking(event);
        }
        return this.processBlocking(event);
    }

    protected MuleEvent processBlocking(MuleEvent event) throws MuleException {
        MessagingException exception = null;
        try {
            MuleEvent muleEvent = this.processResponse(this.processNext(this.processRequest(event)));
            return muleEvent;
        }
        catch (MessagingException e) {
            exception = e;
            throw e;
        }
        finally {
            this.processFinally(event, exception);
        }
    }

    protected MuleEvent processNonBlocking(MuleEvent event) throws MuleException {
        event = new DefaultMuleEvent(event, this.createReplyToHandler(event));
        event = OptimizedRequestContext.unsafeSetEvent(event);
        try {
            MuleEvent result = this.processNext(this.processRequest(event));
            if (!(result instanceof NonBlockingVoidMuleEvent)) {
                MuleEvent after = this.processResponse(result);
                this.processFinally(after, null);
                return after;
            }
            return result;
        }
        catch (MessagingException exception) {
            this.processFinally(event, exception);
            throw exception;
        }
    }

    protected ReplyToHandler createReplyToHandler(MuleEvent event) {
        final ReplyToHandler originalReplyToHandler = event.getReplyToHandler();
        return new ReplyToHandler(){

            @Override
            public void processReplyTo(MuleEvent event, MuleMessage returnMessage, Object replyTo) throws MuleException {
                MuleEvent response = AbstractRequestResponseMessageProcessor.this.processResponse(new DefaultMuleEvent(event, originalReplyToHandler));
                OptimizedRequestContext.unsafeSetEvent(response);
                if (!NonBlockingVoidMuleEvent.getInstance().equals(response)) {
                    originalReplyToHandler.processReplyTo(response, null, null);
                }
                AbstractRequestResponseMessageProcessor.this.processFinally(event, null);
            }

            @Override
            public void processExceptionReplyTo(MessagingException exception, Object replyTo) {
                originalReplyToHandler.processExceptionReplyTo(exception, replyTo);
                AbstractRequestResponseMessageProcessor.this.processFinally(exception.getEvent(), exception);
            }
        };
    }

    private boolean isNonBlocking(MuleEvent event) {
        return event.isAllowNonBlocking() && event.getReplyToHandler() != null && this.next != null;
    }

    protected MuleEvent processRequest(MuleEvent event) throws MuleException {
        return event;
    }

    protected MuleEvent processResponse(MuleEvent event) throws MuleException {
        return event;
    }

    protected void processFinally(MuleEvent event, MessagingException exception) {
    }
}

