/*
 * Decompiled with CFR 0.152.
 */
package org.mule.retry.async;

import javax.resource.spi.work.Work;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.context.WorkManager;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.retry.async.FutureRetryContext;
import org.mule.util.concurrent.Latch;

public class RetryWorker
implements Work {
    protected final transient Log logger = LogFactory.getLog(RetryWorker.class);
    private final RetryCallback callback;
    private final WorkManager workManager;
    private Exception exception = null;
    private final FutureRetryContext context = new FutureRetryContext();
    private final RetryPolicyTemplate delegate;
    private Latch startLatch;

    public RetryWorker(RetryPolicyTemplate delegate, RetryCallback callback, WorkManager workManager) {
        this(delegate, callback, workManager, null);
    }

    public RetryWorker(RetryPolicyTemplate delegate, RetryCallback callback, WorkManager workManager, Latch startLatch) {
        this.callback = callback;
        this.workManager = workManager;
        this.delegate = delegate;
        this.startLatch = startLatch;
        if (this.startLatch == null) {
            this.startLatch = new Latch();
            this.startLatch.countDown();
        }
    }

    public void release() {
    }

    public void run() {
        try {
            this.startLatch.await();
        }
        catch (InterruptedException e) {
            this.logger.warn((Object)("Retry thread interupted for callback: " + this.callback.getWorkDescription()));
            return;
        }
        try {
            this.context.setDelegateContext(this.delegate.execute(this.callback, this.workManager));
        }
        catch (Exception e) {
            this.exception = e;
            this.logger.fatal((Object)e, (Throwable)e);
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public FutureRetryContext getRetryContext() {
        return this.context;
    }
}

