/*
 * Decompiled with CFR 0.152.
 */
package org.mule.streaming;

import java.util.NoSuchElementException;
import org.mule.api.MuleException;
import org.mule.streaming.ClosedConsumerException;
import org.mule.streaming.Consumer;
import org.mule.streaming.Producer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConsumer<T, P>
implements Consumer<T> {
    private static final transient Logger logger = LoggerFactory.getLogger(AbstractConsumer.class);
    protected final Producer<P> producer;
    private boolean closed = false;

    public AbstractConsumer(Producer<P> producer) {
        this.producer = producer;
    }

    protected abstract T doConsume() throws NoSuchElementException;

    protected abstract boolean checkConsumed();

    @Override
    public final T consume() throws NoSuchElementException {
        if (this.closed) {
            throw new ClosedConsumerException("this consumer is already closed");
        }
        if (this.isConsumed()) {
            throw new NoSuchElementException();
        }
        T value = this.doConsume();
        if (value == null) {
            this.closeQuietly();
        }
        return value;
    }

    @Override
    public final boolean isConsumed() {
        if (this.closed) {
            return true;
        }
        boolean isConsumed = this.checkConsumed();
        if (isConsumed) {
            this.closeQuietly();
        }
        return isConsumed;
    }

    @Override
    public void close() throws MuleException {
        this.closed = true;
        this.producer.close();
    }

    @Override
    public int size() {
        return this.producer.size();
    }

    private void closeQuietly() {
        block2: {
            try {
                this.close();
            }
            catch (MuleException e) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("Expection was trapped trying to close consumer", (Throwable)e);
            }
        }
    }
}

