/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.ClassUtils;
import org.mule.util.FileUtils;
import org.mule.util.NumberUtils;

public class IOUtils
extends org.apache.commons.io.IOUtils {
    private static final Log logger = LogFactory.getLog(IOUtils.class);
    protected static int bufferSize = NumberUtils.toInt((String)System.getProperty("mule.streaming.bufferSize"), (int)4096);

    public static String getResourceAsString(String resourceName, Class callingClass) throws IOException {
        InputStream is = IOUtils.getResourceAsStream(resourceName, callingClass);
        if (is != null) {
            return IOUtils.toString(is);
        }
        throw new IOException("Unable to load resource " + resourceName);
    }

    public static InputStream getResourceAsStream(String resourceName, Class callingClass) throws IOException {
        return IOUtils.getResourceAsStream(resourceName, callingClass, true, true);
    }

    public static InputStream getResourceAsStream(String resourceName, Class callingClass, boolean tryAsFile, boolean tryAsUrl) throws IOException {
        URL url = IOUtils.getResourceAsUrl(resourceName, callingClass, tryAsFile, tryAsUrl);
        if (url == null) {
            return null;
        }
        return url.openStream();
    }

    public static URL getResourceAsUrl(String resourceName, Class callingClass) {
        return IOUtils.getResourceAsUrl(resourceName, callingClass, true, true);
    }

    public static URL getResourceAsUrl(final String resourceName, final Class callingClass, boolean tryAsFile, boolean tryAsUrl) {
        if (resourceName == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("Resource name").getMessage());
        }
        URL url = null;
        if (tryAsFile) {
            try {
                File file = FileUtils.newFile(resourceName);
                if (file.exists()) {
                    url = file.getAbsoluteFile().toURL();
                } else {
                    logger.debug((Object)("Unable to load resource from the file system: " + file.getAbsolutePath()));
                }
            }
            catch (Exception e) {
                logger.debug((Object)("Unable to load resource from the file system: " + e.getMessage()));
            }
        }
        if (url == null) {
            try {
                url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return ClassUtils.getResource(resourceName, callingClass);
                    }
                });
                if (url == null) {
                    logger.debug((Object)("Unable to load resource " + resourceName + " from the classpath"));
                }
            }
            catch (Exception e) {
                logger.debug((Object)("Unable to load resource " + resourceName + " from the classpath: " + e.getMessage()));
            }
        }
        if (url == null) {
            try {
                url = new URL(resourceName);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return url;
    }

    public static String toString(InputStream input) {
        try {
            return org.apache.commons.io.IOUtils.toString((InputStream)input);
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
    }

    public static byte[] toByteArray(InputStream input) {
        try {
            return org.apache.commons.io.IOUtils.toByteArray((InputStream)input);
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[bufferSize];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copyLarge(Reader input, Writer output) throws IOException {
        char[] buffer = new char[bufferSize];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

