/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.Serializable;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.QueueStore;
import org.mule.util.store.DefaultObjectStoreFactory;
import org.mule.util.store.MuleDefaultObjectStoreFactory;

public class DefaultObjectStoreFactoryBean {
    private static DefaultObjectStoreFactory delegate = new MuleDefaultObjectStoreFactory();

    private DefaultObjectStoreFactoryBean() {
    }

    public static void setDelegate(DefaultObjectStoreFactory factory) {
        if (delegate == null) {
            throw new IllegalArgumentException("Object store factory cannot be null");
        }
        delegate = factory;
    }

    public static ObjectStore<Serializable> createDefaultInMemoryObjectStore() {
        return delegate.createDefaultInMemoryObjectStore();
    }

    public static ObjectStore<Serializable> createDefaultPersistentObjectStore() {
        return delegate.createDefaultPersistentObjectStore();
    }

    public static QueueStore<Serializable> createDefaultInMemoryQueueStore() {
        return delegate.createDefaultInMemoryQueueStore();
    }

    public static QueueStore<Serializable> createDefaultPersistentQueueStore() {
        return delegate.createDefaultPersistentQueueStore();
    }

    public static ObjectStore<Serializable> createDefaultUserObjectStore() {
        if ("true".equals(System.getProperty("mule.objectstore.user.transient"))) {
            return delegate.createDefaultUserTransientObjectStore();
        }
        return delegate.createDefaultUserObjectStore();
    }

    public static ObjectStore<Serializable> createDefaultUserTransientObjectStore() {
        return delegate.createDefaultUserTransientObjectStore();
    }
}

