/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.maven;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenModelFactory {
    protected static final Logger LOGGER = LoggerFactory.getLogger(MavenModelFactory.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Model createMavenProject(File pomFile) {
        MavenXpp3Reader mavenReader = new MavenXpp3Reader();
        if (pomFile == null) throw new IllegalArgumentException("pom file doesn't exits for path: " + pomFile);
        if (!pomFile.exists()) throw new IllegalArgumentException("pom file doesn't exits for path: " + pomFile);
        try (FileReader reader = new FileReader(pomFile);){
            Model model = mavenReader.read((Reader)reader);
            model.setPomFile(pomFile);
            Model model2 = model;
            return model2;
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't get Maven Artifact from pom: " + pomFile);
        }
    }
}

