/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.standalone.controller;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.tools.client.standalone.controller.AbstractOSController;
import org.mule.tools.client.standalone.exception.MuleControllerException;

public class WindowsController
extends AbstractOSController {
    protected static final String PID_WINDOWS = "(\\s)*PID (\\s)+ :(\\s)*([0-9])+";
    protected static final Pattern PID_PATTERN_WINDOWS = Pattern.compile("(\\s)*PID (\\s)+ :(\\s)*([0-9])+");

    public WindowsController(String muleHome, int timeout) {
        super(muleHome, timeout);
    }

    @Override
    public String getMuleBin() {
        return this.muleHome + "/bin/mule.bat";
    }

    @Override
    public void start(String ... args) {
        this.install(args);
        super.start(args);
    }

    @Override
    public int stop(String ... args) {
        int returnCode = super.stop(args);
        int errorRemove = this.runSync("remove", new String[0]);
        if (errorRemove != 0 && errorRemove != 1060) {
            throw new MuleControllerException("The mule instance couldn't be removed as a service");
        }
        return returnCode;
    }

    @Override
    public int getProcessId() {
        String muleResult = this.executeCmd("sc queryex \"mule\" ");
        String muleEEResult = this.executeCmd("sc queryex \"mule_ee\" ");
        if (muleResult.contains("RUNNING")) {
            return this.getId(muleResult);
        }
        if (muleEEResult.contains("RUNNING")) {
            return this.getId(muleEEResult);
        }
        throw new MuleControllerException("No mule instance is running");
    }

    private int getId(String str) {
        Matcher matcher = PID_PATTERN_WINDOWS.matcher(str);
        if (!matcher.find()) {
            throw new MuleControllerException("PID pattern not recognized in " + str);
        }
        String result = matcher.group(0);
        String[] resultArray = result.split(": ");
        return Integer.parseInt(resultArray[1]);
    }

    @Override
    public int status(String ... args) {
        String muleResult = this.executeCmd("sc queryex \"mule\" ");
        String muleEEResult = this.executeCmd("sc queryex \"mule_ee\" ");
        Boolean result = muleResult.contains("RUNNING") || muleEEResult.contains("RUNNING");
        return result != false ? 0 : 1;
    }

    private String executeCmd(String cmd) {
        StringBuilder output = new StringBuilder();
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = "";
            while ((line = reader.readLine()) != null) {
                output.append(line + "\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output.toString();
    }

    @Override
    public void restart(String ... args) {
        this.install(args);
        super.restart(args);
    }

    private void install(String ... args) {
        int errorInstall = this.runSync("install", args);
        if (errorInstall != 0 && errorInstall != 1073) {
            throw new MuleControllerException("The mule instance couldn't be installed as a service");
        }
    }
}

