/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.standalone.deployment;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.client.standalone.controller.MuleProcessController;
import org.mule.tools.utils.DeployerLog;

public class StandaloneUndeployer {
    private List<File> muleHomes;
    private String applicationName;
    private DeployerLog log;

    public StandaloneUndeployer(DeployerLog log, String applicationName, File ... muleHomes) {
        this.muleHomes = Arrays.asList(muleHomes);
        this.applicationName = applicationName;
        this.log = log;
    }

    public void execute() throws DeploymentException {
        for (File muleHome : this.muleHomes) {
            this.log.info("Undeploying application " + this.applicationName + " from " + muleHome.getAbsolutePath());
            this.undeploy(muleHome);
            this.log.info("Application " + this.applicationName + " undeployed");
            this.log.info("Stopping Mule instance " + muleHome.getAbsolutePath());
            MuleProcessController controller = new MuleProcessController(muleHome.getAbsolutePath());
            controller.stop(new String[0]);
            this.log.info("Mule instance stopped");
        }
    }

    private void undeploy(File muleHome) throws DeploymentException {
        File appsDir = new File(muleHome + "/apps/");
        for (File file : appsDir.listFiles()) {
            if (!FilenameUtils.getBaseName((String)file.getName()).equals(this.applicationName)) continue;
            try {
                this.log.debug("Deleting " + file);
                FileUtils.forceDelete((File)file);
                return;
            }
            catch (IOException e) {
                this.log.error("Could not delete " + file.getAbsolutePath());
                throw new DeploymentException("Could not delete directory [" + file.getAbsolutePath() + "]", e);
            }
        }
        throw new DeploymentException("Application " + this.applicationName + " not found.");
    }
}

