/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.validation.standalone;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.model.Deployment;
import org.mule.tools.model.standalone.StandaloneDeployment;
import org.mule.tools.validation.AbstractDeploymentValidator;
import org.mule.tools.validation.EnvironmentSupportedVersions;
import org.mule.tools.validation.standalone.MuleCoreJarVersionFinder;

public class StandaloneDeploymentValidator
extends AbstractDeploymentValidator {
    public StandaloneDeploymentValidator(Deployment deployment) {
        super(deployment);
    }

    @Override
    public EnvironmentSupportedVersions getEnvironmentSupportedVersions() throws DeploymentException {
        File muleHome = ((StandaloneDeployment)this.deployment).getMuleHome();
        Preconditions.checkArgument((muleHome != null ? 1 : 0) != 0, (Object)"Mule home cannot not be null");
        Preconditions.checkArgument((boolean)muleHome.exists(), (Object)"Mule home directory does not exist");
        String muleRuntimeVersion = this.findRuntimeVersion(muleHome);
        return new EnvironmentSupportedVersions(muleRuntimeVersion);
    }

    private String findRuntimeVersion(File muleHome) throws DeploymentException {
        MuleCoreJarVersionFinder muleCoreJarVersionFinder = new MuleCoreJarVersionFinder();
        try {
            Files.walkFileTree(muleHome.toPath(), muleCoreJarVersionFinder);
        }
        catch (IOException e) {
            throw new DeploymentException("Error trying to resolve Mule Standalone version", e);
        }
        return muleCoreJarVersionFinder.getMuleCoreVersion();
    }
}

