/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.util.Map;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connector;
import org.mule.transport.http.HttpsPollingConnector;
import org.mule.transport.http.PollingHttpMessageReceiver;
import org.mule.transport.http.i18n.HttpMessages;
import org.mule.util.MapUtils;

public class PollingHttpsMessageReceiver
extends PollingHttpMessageReceiver {
    public PollingHttpsMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
    }

    @Override
    protected void setupFromConnector(Connector connector) throws CreateException {
        if (!(connector instanceof HttpsPollingConnector)) {
            throw new CreateException(HttpMessages.pollingReciverCannotbeUsed(), (Object)this);
        }
        HttpsPollingConnector pollingConnector = (HttpsPollingConnector)connector;
        long pollingFrequency = MapUtils.getLongValue((Map)this.endpoint.getProperties(), (Object)"pollingFrequency", (long)pollingConnector.getPollingFrequency());
        if (pollingFrequency > 0L) {
            this.setFrequency(pollingFrequency);
        }
        this.checkEtag = MapUtils.getBooleanValue((Map)this.endpoint.getProperties(), (Object)"checkEtag", (boolean)pollingConnector.isCheckEtag());
        this.discardEmptyContent = MapUtils.getBooleanValue((Map)this.endpoint.getProperties(), (Object)"discardEmptyContent", (boolean)pollingConnector.isDiscardEmptyContent());
    }
}

