/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.tcp.protocols;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.mule.transport.tcp.protocols.AbstractByteProtocol;

public class XmlMessageProtocol
extends AbstractByteProtocol {
    private static final String XML_PATTERN = "<?xml";
    private static final int READ_BUFFER_SIZE = 4096;
    private static final int PUSHBACK_BUFFER_SIZE = 8192;
    private ConcurrentMap pbMap = new ConcurrentHashMap();

    public XmlMessageProtocol() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object read(InputStream is) throws IOException {
        PushbackInputStream pbis = (PushbackInputStream)this.pbMap.get(is);
        if (null == pbis) {
            pbis = new PushbackInputStream(is, 8192);
            PushbackInputStream prev = this.pbMap.putIfAbsent(is, pbis);
            pbis = null == prev ? pbis : prev;
        }
        int len = -1;
        try {
            boolean repeat;
            byte[] buffer = new byte[4096];
            StringBuilder message = new StringBuilder(4096);
            int patternIndex = -1;
            do {
                if ((len = this.safeRead(pbis, buffer)) >= 0) {
                    message.append(new String(buffer, 0, len));
                    patternIndex = message.toString().indexOf(XML_PATTERN, 1);
                    repeat = this.isRepeat(patternIndex, len, pbis.available());
                    continue;
                }
                repeat = false;
            } while (repeat);
            if (patternIndex > 0) {
                pbis.unread(message.substring(patternIndex, message.length()).getBytes());
                message.setLength(patternIndex);
            }
            byte[] byArray = this.nullEmptyArray(message.toString().getBytes());
            return byArray;
        }
        finally {
            if (len < 0) {
                this.pbMap.remove(is);
            }
        }
    }

    protected boolean isRepeat(int patternIndex, int len, int available) {
        return patternIndex < 0 && len == 4096 && available > 0;
    }
}

