var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import React, { useCallback, useState, } from 'react';
import { Button, ButtonGroup, ChevronDownIcon, ChevronUpIcon, CopyIcon, Dialog, ExecuteButton, GraphiQLProvider, HeaderEditor, KeyboardShortcutIcon, MergeIcon, PlusIcon, PrettifyIcon, QueryEditor, ReloadIcon, ResponseEditor, SettingsIcon, Spinner, Tab, Tabs, ToolbarButton, Tooltip, UnStyledButton, useCopyQuery, useDragResize, useEditorContext, useExecutionContext, useMergeQuery, usePluginContext, usePrettifyEditors, useSchemaContext, useStorageContext, useTheme, VariableEditor, } from '@graphiql/react';
var majorVersion = parseInt(React.version.slice(0, 2), 10);
if (majorVersion < 16) {
    throw new Error([
        'GraphiQL 0.18.0 and after is not compatible with React 15 or below.',
        'If you are using a CDN source (jsdelivr, unpkg, etc), follow this example:',
        'https://github.com/graphql/graphiql/blob/master/examples/graphiql-cdn/index.html#L49',
    ].join('\n'));
}
export function GraphiQL(_a) {
    var dangerouslyAssumeSchemaIsValid = _a.dangerouslyAssumeSchemaIsValid, defaultQuery = _a.defaultQuery, defaultTabs = _a.defaultTabs, externalFragments = _a.externalFragments, fetcher = _a.fetcher, getDefaultFieldNames = _a.getDefaultFieldNames, headers = _a.headers, initialTabs = _a.initialTabs, inputValueDeprecation = _a.inputValueDeprecation, introspectionQueryName = _a.introspectionQueryName, maxHistoryLength = _a.maxHistoryLength, onEditOperationName = _a.onEditOperationName, onSchemaChange = _a.onSchemaChange, onTabChange = _a.onTabChange, onTogglePluginVisibility = _a.onTogglePluginVisibility, operationName = _a.operationName, plugins = _a.plugins, query = _a.query, response = _a.response, schema = _a.schema, schemaDescription = _a.schemaDescription, shouldPersistHeaders = _a.shouldPersistHeaders, storage = _a.storage, validationRules = _a.validationRules, variables = _a.variables, visiblePlugin = _a.visiblePlugin, defaultHeaders = _a.defaultHeaders, props = __rest(_a, ["dangerouslyAssumeSchemaIsValid", "defaultQuery", "defaultTabs", "externalFragments", "fetcher", "getDefaultFieldNames", "headers", "initialTabs", "inputValueDeprecation", "introspectionQueryName", "maxHistoryLength", "onEditOperationName", "onSchemaChange", "onTabChange", "onTogglePluginVisibility", "operationName", "plugins", "query", "response", "schema", "schemaDescription", "shouldPersistHeaders", "storage", "validationRules", "variables", "visiblePlugin", "defaultHeaders"]);
    if (typeof fetcher !== 'function') {
        throw new TypeError('The `GraphiQL` component requires a `fetcher` function to be passed as prop.');
    }
    return (React.createElement(GraphiQLProvider, { getDefaultFieldNames: getDefaultFieldNames, dangerouslyAssumeSchemaIsValid: dangerouslyAssumeSchemaIsValid, defaultQuery: defaultQuery, defaultHeaders: defaultHeaders, defaultTabs: defaultTabs, externalFragments: externalFragments, fetcher: fetcher, headers: headers, initialTabs: initialTabs, inputValueDeprecation: inputValueDeprecation, introspectionQueryName: introspectionQueryName, maxHistoryLength: maxHistoryLength, onEditOperationName: onEditOperationName, onSchemaChange: onSchemaChange, onTabChange: onTabChange, onTogglePluginVisibility: onTogglePluginVisibility, plugins: plugins, visiblePlugin: visiblePlugin, operationName: operationName, query: query, response: response, schema: schema, schemaDescription: schemaDescription, shouldPersistHeaders: shouldPersistHeaders, storage: storage, validationRules: validationRules, variables: variables },
        React.createElement(GraphiQLInterface, __assign({ showPersistHeadersSettings: shouldPersistHeaders !== false }, props))));
}
GraphiQL.Logo = GraphiQLLogo;
GraphiQL.Toolbar = GraphiQLToolbar;
GraphiQL.Footer = GraphiQLFooter;
var modifier = typeof window !== 'undefined' &&
    window.navigator.platform.toLowerCase().indexOf('mac') === 0 ? (React.createElement("code", { className: "graphiql-key" }, "Cmd")) : (React.createElement("code", { className: "graphiql-key" }, "Ctrl"));
export function GraphiQLInterface(props) {
    var _a, _b, _c;
    var isHeadersEditorEnabled = (_a = props.isHeadersEditorEnabled) !== null && _a !== void 0 ? _a : true;
    var editorContext = useEditorContext({ nonNull: true });
    var executionContext = useExecutionContext({ nonNull: true });
    var schemaContext = useSchemaContext({ nonNull: true });
    var storageContext = useStorageContext();
    var pluginContext = usePluginContext();
    var copy = useCopyQuery({ onCopyQuery: props.onCopyQuery });
    var merge = useMergeQuery();
    var prettify = usePrettifyEditors();
    var _d = useTheme(), theme = _d.theme, setTheme = _d.setTheme;
    var PluginContent = (_b = pluginContext === null || pluginContext === void 0 ? void 0 : pluginContext.visiblePlugin) === null || _b === void 0 ? void 0 : _b.content;
    var pluginResize = useDragResize({
        defaultSizeRelation: 1 / 3,
        direction: 'horizontal',
        initiallyHidden: (pluginContext === null || pluginContext === void 0 ? void 0 : pluginContext.visiblePlugin) ? undefined : 'first',
        onHiddenElementChange: function (resizableElement) {
            if (resizableElement === 'first') {
                pluginContext === null || pluginContext === void 0 ? void 0 : pluginContext.setVisiblePlugin(null);
            }
        },
        sizeThresholdSecond: 200,
        storageKey: 'docExplorerFlex',
    });
    var editorResize = useDragResize({
        direction: 'horizontal',
        storageKey: 'editorFlex',
    });
    var editorToolsResize = useDragResize({
        defaultSizeRelation: 3,
        direction: 'vertical',
        initiallyHidden: (function () {
            if (props.defaultEditorToolsVisibility === 'variables' ||
                props.defaultEditorToolsVisibility === 'headers') {
                return;
            }
            if (typeof props.defaultEditorToolsVisibility === 'boolean') {
                return props.defaultEditorToolsVisibility ? undefined : 'second';
            }
            return editorContext.initialVariables || editorContext.initialHeaders
                ? undefined
                : 'second';
        })(),
        sizeThresholdSecond: 60,
        storageKey: 'secondaryEditorFlex',
    });
    var _e = __read(useState(function () {
        if (props.defaultEditorToolsVisibility === 'variables' ||
            props.defaultEditorToolsVisibility === 'headers') {
            return props.defaultEditorToolsVisibility;
        }
        return !editorContext.initialVariables &&
            editorContext.initialHeaders &&
            isHeadersEditorEnabled
            ? 'headers'
            : 'variables';
    }), 2), activeSecondaryEditor = _e[0], setActiveSecondaryEditor = _e[1];
    var _f = __read(useState(null), 2), showDialog = _f[0], setShowDialog = _f[1];
    var _g = __read(useState(null), 2), clearStorageStatus = _g[0], setClearStorageStatus = _g[1];
    var children = React.Children.toArray(props.children);
    var logo = children.find(function (child) {
        return isChildComponentType(child, GraphiQL.Logo);
    }) || React.createElement(GraphiQL.Logo, null);
    var toolbar = children.find(function (child) {
        return isChildComponentType(child, GraphiQL.Toolbar);
    }) || (React.createElement(React.Fragment, null,
        React.createElement(ToolbarButton, { onClick: prettify, label: "Prettify query (Shift-Ctrl-P)" },
            React.createElement(PrettifyIcon, { className: "graphiql-toolbar-icon", "aria-hidden": "true" })),
        React.createElement(ToolbarButton, { onClick: merge, label: "Merge fragments into query (Shift-Ctrl-M)" },
            React.createElement(MergeIcon, { className: "graphiql-toolbar-icon", "aria-hidden": "true" })),
        React.createElement(ToolbarButton, { onClick: copy, label: "Copy query (Shift-Ctrl-C)" },
            React.createElement(CopyIcon, { className: "graphiql-toolbar-icon", "aria-hidden": "true" })),
        ((_c = props.toolbar) === null || _c === void 0 ? void 0 : _c.additionalContent) || null));
    var footer = children.find(function (child) {
        return isChildComponentType(child, GraphiQL.Footer);
    });
    var onClickReference = useCallback(function () {
        if (pluginResize.hiddenElement === 'first') {
            pluginResize.setHiddenElement(null);
        }
    }, [pluginResize]);
    var handleClearData = useCallback(function () {
        try {
            storageContext === null || storageContext === void 0 ? void 0 : storageContext.clear();
            setClearStorageStatus('success');
        }
        catch (_a) {
            setClearStorageStatus('error');
        }
    }, [storageContext]);
    var handlePersistHeaders = useCallback(function (event) {
        editorContext.setShouldPersistHeaders(event.currentTarget.dataset.value === 'true');
    }, [editorContext]);
    var handleChangeTheme = useCallback(function (event) {
        var selectedTheme = event.currentTarget.dataset.theme;
        setTheme(selectedTheme || null);
    }, [setTheme]);
    var handleAddTab = editorContext.addTab;
    var handleRefetchSchema = schemaContext.introspect;
    var handleShowDialog = useCallback(function (event) {
        setShowDialog(event.currentTarget.dataset.value);
    }, []);
    var handlePluginClick = useCallback(function (e) {
        var context = pluginContext;
        var pluginIndex = Number(e.currentTarget.dataset.index);
        var plugin = context.plugins.find(function (_, index) { return pluginIndex === index; });
        var isVisible = plugin === context.visiblePlugin;
        if (isVisible) {
            context.setVisiblePlugin(null);
            pluginResize.setHiddenElement('first');
        }
        else {
            context.setVisiblePlugin(plugin);
            pluginResize.setHiddenElement(null);
        }
    }, [pluginContext, pluginResize]);
    var handleVariablesTabClick = useCallback(function () {
        if (editorToolsResize.hiddenElement === 'second') {
            editorToolsResize.setHiddenElement(null);
        }
        setActiveSecondaryEditor('variables');
    }, [editorToolsResize]);
    var handleHeadersTabClick = useCallback(function () {
        if (editorToolsResize.hiddenElement === 'second') {
            editorToolsResize.setHiddenElement(null);
        }
        setActiveSecondaryEditor('headers');
    }, [editorToolsResize]);
    var toggleEditorTools = useCallback(function () {
        editorToolsResize.setHiddenElement(editorToolsResize.hiddenElement === 'second' ? null : 'second');
    }, [editorToolsResize]);
    var handleDismissShortKeysDialog = useCallback(function () {
        setShowDialog(null);
    }, []);
    var handleDismissSettingsDialog = useCallback(function () {
        setShowDialog(null);
        setClearStorageStatus(null);
    }, []);
    return (React.createElement("div", { "data-testid": "graphiql-container", className: "graphiql-container" },
        React.createElement("div", { className: "graphiql-sidebar" },
            React.createElement("div", { className: "graphiql-sidebar-section" }, pluginContext === null || pluginContext === void 0 ? void 0 : pluginContext.plugins.map(function (plugin, index) {
                var isVisible = plugin === pluginContext.visiblePlugin;
                var label = "".concat(isVisible ? 'Hide' : 'Show', " ").concat(plugin.title);
                var Icon = plugin.icon;
                return (React.createElement(Tooltip, { key: plugin.title, label: label },
                    React.createElement(UnStyledButton, { type: "button", className: isVisible ? 'active' : '', onClick: handlePluginClick, "data-index": index, "aria-label": label },
                        React.createElement(Icon, { "aria-hidden": "true" }))));
            })),
            React.createElement("div", { className: "graphiql-sidebar-section" },
                React.createElement(Tooltip, { label: "Re-fetch GraphQL schema" },
                    React.createElement(UnStyledButton, { type: "button", disabled: schemaContext.isFetching, onClick: handleRefetchSchema, "aria-label": "Re-fetch GraphQL schema" },
                        React.createElement(ReloadIcon, { className: schemaContext.isFetching ? 'graphiql-spin' : '', "aria-hidden": "true" }))),
                React.createElement(Tooltip, { label: "Open short keys dialog" },
                    React.createElement(UnStyledButton, { type: "button", "data-value": "short-keys", onClick: handleShowDialog, "aria-label": "Open short keys dialog" },
                        React.createElement(KeyboardShortcutIcon, { "aria-hidden": "true" }))),
                React.createElement(Tooltip, { label: "Open settings dialog" },
                    React.createElement(UnStyledButton, { type: "button", "data-value": "settings", onClick: handleShowDialog, "aria-label": "Open settings dialog" },
                        React.createElement(SettingsIcon, { "aria-hidden": "true" }))))),
        React.createElement("div", { className: "graphiql-main" },
            React.createElement("div", { ref: pluginResize.firstRef, style: {
                    minWidth: '200px',
                } },
                React.createElement("div", { className: "graphiql-plugin" }, PluginContent ? React.createElement(PluginContent, null) : null)),
            React.createElement("div", { ref: pluginResize.dragBarRef }, (pluginContext === null || pluginContext === void 0 ? void 0 : pluginContext.visiblePlugin) ? (React.createElement("div", { className: "graphiql-horizontal-drag-bar" })) : null),
            React.createElement("div", { ref: pluginResize.secondRef, style: { minWidth: 0 } },
                React.createElement("div", { className: "graphiql-sessions" },
                    React.createElement("div", { className: "graphiql-session-header" },
                        React.createElement(Tabs, { "aria-label": "Select active operation" }, editorContext.tabs.length > 1 ? (React.createElement(React.Fragment, null,
                            editorContext.tabs.map(function (tab, index) { return (React.createElement(Tab, { key: tab.id, isActive: index === editorContext.activeTabIndex },
                                React.createElement(Tab.Button, { "aria-controls": "graphiql-session", id: "graphiql-session-tab-".concat(index), onClick: function () {
                                        executionContext.stop();
                                        editorContext.changeTab(index);
                                    } }, tab.title),
                                React.createElement(Tab.Close, { onClick: function () {
                                        if (editorContext.activeTabIndex === index) {
                                            executionContext.stop();
                                        }
                                        editorContext.closeTab(index);
                                    } }))); }),
                            React.createElement("div", null,
                                React.createElement(Tooltip, { label: "Add tab" },
                                    React.createElement(UnStyledButton, { type: "button", className: "graphiql-tab-add", onClick: handleAddTab, "aria-label": "Add tab" },
                                        React.createElement(PlusIcon, { "aria-hidden": "true" })))))) : null),
                        React.createElement("div", { className: "graphiql-session-header-right" },
                            editorContext.tabs.length === 1 ? (React.createElement("div", { className: "graphiql-add-tab-wrapper" },
                                React.createElement(Tooltip, { label: "Add tab" },
                                    React.createElement(UnStyledButton, { type: "button", className: "graphiql-tab-add", onClick: handleAddTab, "aria-label": "Add tab" },
                                        React.createElement(PlusIcon, { "aria-hidden": "true" }))))) : null,
                            logo)),
                    React.createElement("div", { role: "tabpanel", id: "graphiql-session", className: "graphiql-session", "aria-labelledby": "graphiql-session-tab-".concat(editorContext.activeTabIndex) },
                        React.createElement("div", { ref: editorResize.firstRef },
                            React.createElement("div", { className: "graphiql-editors".concat(editorContext.tabs.length === 1 ? ' full-height' : '') },
                                React.createElement("div", { ref: editorToolsResize.firstRef },
                                    React.createElement("section", { className: "graphiql-query-editor", "aria-label": "Query Editor" },
                                        React.createElement("div", { className: "graphiql-query-editor-wrapper" },
                                            React.createElement(QueryEditor, { editorTheme: props.editorTheme, keyMap: props.keyMap, onClickReference: onClickReference, onCopyQuery: props.onCopyQuery, onEdit: props.onEditQuery, readOnly: props.readOnly })),
                                        React.createElement("div", { className: "graphiql-toolbar", role: "toolbar", "aria-label": "Editor Commands" },
                                            React.createElement(ExecuteButton, null),
                                            toolbar))),
                                React.createElement("div", { ref: editorToolsResize.dragBarRef },
                                    React.createElement("div", { className: "graphiql-editor-tools" },
                                        React.createElement("div", { className: "graphiql-editor-tools-tabs" },
                                            React.createElement(UnStyledButton, { type: "button", className: activeSecondaryEditor === 'variables' &&
                                                    editorToolsResize.hiddenElement !== 'second'
                                                    ? 'active'
                                                    : '', onClick: handleVariablesTabClick }, "Variables"),
                                            isHeadersEditorEnabled ? (React.createElement(UnStyledButton, { type: "button", className: activeSecondaryEditor === 'headers' &&
                                                    editorToolsResize.hiddenElement !== 'second'
                                                    ? 'active'
                                                    : '', onClick: handleHeadersTabClick }, "Headers")) : null),
                                        React.createElement(Tooltip, { label: editorToolsResize.hiddenElement === 'second'
                                                ? 'Show editor tools'
                                                : 'Hide editor tools' },
                                            React.createElement(UnStyledButton, { type: "button", onClick: toggleEditorTools, "aria-label": editorToolsResize.hiddenElement === 'second'
                                                    ? 'Show editor tools'
                                                    : 'Hide editor tools' }, editorToolsResize.hiddenElement === 'second' ? (React.createElement(ChevronUpIcon, { className: "graphiql-chevron-icon", "aria-hidden": "true" })) : (React.createElement(ChevronDownIcon, { className: "graphiql-chevron-icon", "aria-hidden": "true" })))))),
                                React.createElement("div", { ref: editorToolsResize.secondRef },
                                    React.createElement("section", { className: "graphiql-editor-tool", "aria-label": activeSecondaryEditor === 'variables'
                                            ? 'Variables'
                                            : 'Headers' },
                                        React.createElement(VariableEditor, { editorTheme: props.editorTheme, isHidden: activeSecondaryEditor !== 'variables', keyMap: props.keyMap, onEdit: props.onEditVariables, onClickReference: onClickReference, readOnly: props.readOnly }),
                                        isHeadersEditorEnabled && (React.createElement(HeaderEditor, { editorTheme: props.editorTheme, isHidden: activeSecondaryEditor !== 'headers', keyMap: props.keyMap, onEdit: props.onEditHeaders, readOnly: props.readOnly })))))),
                        React.createElement("div", { ref: editorResize.dragBarRef },
                            React.createElement("div", { className: "graphiql-horizontal-drag-bar" })),
                        React.createElement("div", { ref: editorResize.secondRef },
                            React.createElement("div", { className: "graphiql-response" },
                                executionContext.isFetching ? React.createElement(Spinner, null) : null,
                                React.createElement(ResponseEditor, { editorTheme: props.editorTheme, responseTooltip: props.responseTooltip, keyMap: props.keyMap }),
                                footer)))))),
        React.createElement(Dialog, { isOpen: showDialog === 'short-keys', onDismiss: handleDismissShortKeysDialog },
            React.createElement("div", { className: "graphiql-dialog-header" },
                React.createElement("div", { className: "graphiql-dialog-title" }, "Short Keys"),
                React.createElement(Dialog.Close, { onClick: handleDismissShortKeysDialog })),
            React.createElement("div", { className: "graphiql-dialog-section" },
                React.createElement("div", null,
                    React.createElement("table", { className: "graphiql-table" },
                        React.createElement("thead", null,
                            React.createElement("tr", null,
                                React.createElement("th", null, "Short key"),
                                React.createElement("th", null, "Function"))),
                        React.createElement("tbody", null,
                            React.createElement("tr", null,
                                React.createElement("td", null,
                                    modifier,
                                    ' + ',
                                    React.createElement("code", { className: "graphiql-key" }, "F")),
                                React.createElement("td", null, "Search in editor")),
                            React.createElement("tr", null,
                                React.createElement("td", null,
                                    modifier,
                                    ' + ',
                                    React.createElement("code", { className: "graphiql-key" }, "K")),
                                React.createElement("td", null, "Search in documentation")),
                            React.createElement("tr", null,
                                React.createElement("td", null,
                                    modifier,
                                    ' + ',
                                    React.createElement("code", { className: "graphiql-key" }, "Enter")),
                                React.createElement("td", null, "Execute query")),
                            React.createElement("tr", null,
                                React.createElement("td", null,
                                    React.createElement("code", { className: "graphiql-key" }, "Ctrl"),
                                    ' + ',
                                    React.createElement("code", { className: "graphiql-key" }, "Shift"),
                                    ' + ',
                                    React.createElement("code", { className: "graphiql-key" }, "P")),
                                React.createElement("td", null, "Prettify editors")),
                            React.createElement("tr", null,
                                React.createElement("td", null,
                                    React.createElement("code", { className: "graphiql-key" }, "Ctrl"),
                                    ' + ',
                                    React.createElement("code", { className: "graphiql-key" }, "Shift"),
                                    ' + ',
                                    React.createElement("code", { className: "graphiql-key" }, "M")),
                                React.createElement("td", null, "Merge fragments definitions into operation definition")),
                            React.createElement("tr", null,
                                React.createElement("td", null,
                                    React.createElement("code", { className: "graphiql-key" }, "Ctrl"),
                                    ' + ',
                                    React.createElement("code", { className: "graphiql-key" }, "Shift"),
                                    ' + ',
                                    React.createElement("code", { className: "graphiql-key" }, "C")),
                                React.createElement("td", null, "Copy query")),
                            React.createElement("tr", null,
                                React.createElement("td", null,
                                    React.createElement("code", { className: "graphiql-key" }, "Ctrl"),
                                    ' + ',
                                    React.createElement("code", { className: "graphiql-key" }, "Shift"),
                                    ' + ',
                                    React.createElement("code", { className: "graphiql-key" }, "R")),
                                React.createElement("td", null, "Re-fetch schema using introspection")))),
                    React.createElement("p", null,
                        "The editors use",
                        ' ',
                        React.createElement("a", { href: "https://codemirror.net/5/doc/manual.html#keymaps", target: "_blank", rel: "noopener noreferrer" }, "CodeMirror Key Maps"),
                        ' ',
                        "that add more short keys. This instance of Graph",
                        React.createElement("em", null, "i"),
                        "QL uses",
                        ' ',
                        React.createElement("code", null, props.keyMap || 'sublime'),
                        ".")))),
        React.createElement(Dialog, { isOpen: showDialog === 'settings', onDismiss: handleDismissSettingsDialog },
            React.createElement("div", { className: "graphiql-dialog-header" },
                React.createElement("div", { className: "graphiql-dialog-title" }, "Settings"),
                React.createElement(Dialog.Close, { onClick: handleDismissSettingsDialog })),
            props.showPersistHeadersSettings ? (React.createElement("div", { className: "graphiql-dialog-section" },
                React.createElement("div", null,
                    React.createElement("div", { className: "graphiql-dialog-section-title" }, "Persist headers"),
                    React.createElement("div", { className: "graphiql-dialog-section-caption" },
                        "Save headers upon reloading.",
                        ' ',
                        React.createElement("span", { className: "graphiql-warning-text" }, "Only enable if you trust this device."))),
                React.createElement(ButtonGroup, null,
                    React.createElement(Button, { type: "button", id: "enable-persist-headers", className: editorContext.shouldPersistHeaders ? 'active' : '', "data-value": "true", onClick: handlePersistHeaders }, "On"),
                    React.createElement(Button, { type: "button", id: "disable-persist-headers", className: editorContext.shouldPersistHeaders ? '' : 'active', onClick: handlePersistHeaders }, "Off")))) : null,
            React.createElement("div", { className: "graphiql-dialog-section" },
                React.createElement("div", null,
                    React.createElement("div", { className: "graphiql-dialog-section-title" }, "Theme"),
                    React.createElement("div", { className: "graphiql-dialog-section-caption" }, "Adjust how the interface looks like.")),
                React.createElement("div", null,
                    React.createElement(ButtonGroup, null,
                        React.createElement(Button, { type: "button", className: theme === null ? 'active' : '', onClick: handleChangeTheme }, "System"),
                        React.createElement(Button, { type: "button", className: theme === 'light' ? 'active' : '', "data-theme": "light", onClick: handleChangeTheme }, "Light"),
                        React.createElement(Button, { type: "button", className: theme === 'dark' ? 'active' : '', "data-theme": "dark", onClick: handleChangeTheme }, "Dark")))),
            storageContext ? (React.createElement("div", { className: "graphiql-dialog-section" },
                React.createElement("div", null,
                    React.createElement("div", { className: "graphiql-dialog-section-title" }, "Clear storage"),
                    React.createElement("div", { className: "graphiql-dialog-section-caption" }, "Remove all locally stored data and start fresh.")),
                React.createElement("div", null,
                    React.createElement(Button, { type: "button", state: clearStorageStatus || undefined, disabled: clearStorageStatus === 'success', onClick: handleClearData }, clearStorageStatus === 'success'
                        ? 'Cleared data'
                        : clearStorageStatus === 'error'
                            ? 'Failed'
                            : 'Clear data')))) : null)));
}
function GraphiQLLogo(props) {
    return (React.createElement("div", { className: "graphiql-logo" }, props.children || (React.createElement("a", { className: "graphiql-logo-link", href: "https://github.com/graphql/graphiql", target: "_blank", rel: "noreferrer" },
        "Graph",
        React.createElement("em", null, "i"),
        "QL"))));
}
GraphiQLLogo.displayName = 'GraphiQLLogo';
function GraphiQLToolbar(props) {
    return React.createElement(React.Fragment, null, props.children);
}
GraphiQLToolbar.displayName = 'GraphiQLToolbar';
function GraphiQLFooter(props) {
    return React.createElement("div", { className: "graphiql-footer" }, props.children);
}
GraphiQLFooter.displayName = 'GraphiQLFooter';
function isChildComponentType(child, component) {
    var _a;
    if (((_a = child === null || child === void 0 ? void 0 : child.type) === null || _a === void 0 ? void 0 : _a.displayName) &&
        child.type.displayName === component.displayName) {
        return true;
    }
    return child.type === component;
}
//# sourceMappingURL=GraphiQL.js.map