/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.jackson.datatype.joda.deser;

import java.io.IOException;
import java.util.TimeZone;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.nd4j.shade.jackson.core.JsonParser;
import org.nd4j.shade.jackson.core.JsonToken;
import org.nd4j.shade.jackson.databind.DeserializationContext;
import org.nd4j.shade.jackson.datatype.joda.cfg.FormatConfig;
import org.nd4j.shade.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import org.nd4j.shade.jackson.datatype.joda.deser.JodaDateDeserializerBase;

public class IntervalDeserializer
extends JodaDateDeserializerBase<Interval> {
    private static final long serialVersionUID = 1L;

    public IntervalDeserializer() {
        this(FormatConfig.DEFAULT_DATETIME_PARSER);
    }

    public IntervalDeserializer(JacksonJodaDateFormat format) {
        super(Interval.class, format);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format) {
        return new IntervalDeserializer(format);
    }

    @Override
    public Interval deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        DateTimeZone tz;
        Interval result;
        boolean hasSlash;
        if (!p.hasToken(JsonToken.VALUE_STRING)) {
            return (Interval)ctxt.handleUnexpectedToken(this.handledType(), p.getCurrentToken(), p, "expected JSON String", new Object[0]);
        }
        String v = p.getText().trim();
        int index = v.indexOf(47, 1);
        boolean bl = hasSlash = index > 0;
        if (!hasSlash) {
            index = v.indexOf(45, 1);
        }
        if (index < 0) {
            throw ctxt.weirdStringException(v, this.handledType(), "no slash or hyphen found to separate start, end");
        }
        String str = v.substring(0, index);
        try {
            if (hasSlash) {
                result = Interval.parse((String)v);
            } else {
                long start = Long.valueOf(str);
                str = v.substring(index + 1);
                long end = Long.valueOf(str);
                result = new Interval(start, end);
            }
        }
        catch (NumberFormatException e) {
            return (Interval)ctxt.handleWeirdStringValue(this.handledType(), str, "Failed to parse number from '%s' (full source String '%s')", str, v);
        }
        DateTimeZone dateTimeZone = tz = this._format.isTimezoneExplicit() ? this._format.getTimeZone() : DateTimeZone.forTimeZone((TimeZone)ctxt.getTimeZone());
        if (tz != null && !tz.equals((Object)result.getStart().getZone())) {
            result = new Interval(result.getStartMillis(), result.getEndMillis(), tz);
        }
        return result;
    }
}

