/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.provider.Arguments;
import org.nd4j.common.config.ND4JClassLoading;
import org.nd4j.common.io.ReflectionUtils;
import org.nd4j.common.tests.BaseND4JTest;
import org.nd4j.linalg.Nd4jTestSuite;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.factory.Nd4jBackend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseNd4jTestWithBackends
extends BaseND4JTest {
    private static final Logger log = LoggerFactory.getLogger(BaseNd4jTestWithBackends.class);
    public static List<Nd4jBackend> BACKENDS = new ArrayList<Nd4jBackend>();
    public static final String DEFAULT_BACKEND = "org.nd4j.linalg.defaultbackend";

    public static Stream<Arguments> configs() {
        Stream<Arguments> ret = BACKENDS.stream().map(input -> Arguments.of((Object[])new Object[]{input}));
        return ret;
    }

    @BeforeEach
    public void beforeTest2() {
        Nd4j.factory().setOrder(this.ordering());
    }

    public static Nd4jBackend getDefaultBackend() {
        String cpuBackend = "org.nd4j.linalg.cpu.nativecpu.CpuBackend";
        String defaultBackendClass = System.getProperty(DEFAULT_BACKEND, cpuBackend);
        Class backendClass = ND4JClassLoading.loadClassByName((String)defaultBackendClass);
        return (Nd4jBackend)ReflectionUtils.newInstance((Class)backendClass, (Object[])new Object[0]);
    }

    public char ordering() {
        return 'c';
    }

    public String getFailureMessage(Nd4jBackend backend) {
        return "Failed with backend " + backend.getClass().getName() + " and ordering " + this.ordering();
    }

    static {
        List<String> backendsToRun = Nd4jTestSuite.backendsToRun();
        ServiceLoader loadedBackends = ND4JClassLoading.loadService(Nd4jBackend.class);
        for (Nd4jBackend backend : loadedBackends) {
            if ((!backend.canRun() || !backendsToRun.contains(backend.getClass().getName())) && !backendsToRun.isEmpty()) continue;
            BACKENDS.add(backend);
        }
    }
}

