/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.buffer;

import java.nio.ByteBuffer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.jcublas.buffer.BaseCudaDataBuffer;

public class CudaBfloat16DataBuffer
extends BaseCudaDataBuffer {
    public CudaBfloat16DataBuffer(Pointer pointer, Indexer indexer, long length) {
        super(pointer, indexer, length);
    }

    public CudaBfloat16DataBuffer(Pointer pointer, Pointer specialPointer, Indexer indexer, long length) {
        super(pointer, specialPointer, indexer, length);
    }

    public CudaBfloat16DataBuffer(ByteBuffer buffer, DataType dataType, long length, long offset) {
        super(buffer, dataType, length, offset);
    }

    public CudaBfloat16DataBuffer(long length) {
        super(length, 2);
    }

    public CudaBfloat16DataBuffer(long length, boolean initialize) {
        super(length, 2, initialize);
    }

    public CudaBfloat16DataBuffer(long length, int elementSize) {
        super(length, elementSize);
    }

    public CudaBfloat16DataBuffer(long length, int elementSize, long offset) {
        super(length, elementSize, offset);
    }

    public CudaBfloat16DataBuffer(long length, boolean initialize, MemoryWorkspace workspace) {
        super(length, 2, initialize, workspace);
    }

    public CudaBfloat16DataBuffer(float[] data, boolean copy, MemoryWorkspace workspace) {
        super(data, copy, 0L, workspace);
    }

    protected void initTypeAndSize() {
        this.elementSize = (byte)2;
        this.type = DataType.BFLOAT16;
    }

    public CudaBfloat16DataBuffer(DataBuffer underlyingBuffer, long length, long offset) {
        super(underlyingBuffer, length, offset);
    }

    public CudaBfloat16DataBuffer(float[] buffer) {
        super(buffer);
    }

    public CudaBfloat16DataBuffer(float[] data, boolean copy) {
        super(data, copy);
    }

    public CudaBfloat16DataBuffer(float[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    public CudaBfloat16DataBuffer(float[] data, boolean copy, long offset, MemoryWorkspace workspace) {
        super(data, copy, offset, workspace);
    }

    public CudaBfloat16DataBuffer(double[] data) {
        super(data);
    }

    public CudaBfloat16DataBuffer(double[] data, boolean copy) {
        super(data, copy);
    }

    public CudaBfloat16DataBuffer(double[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    public CudaBfloat16DataBuffer(int[] data) {
        super(data);
    }

    public CudaBfloat16DataBuffer(int[] data, boolean copy) {
        super(data, copy);
    }

    public CudaBfloat16DataBuffer(int[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    @Override
    public void assign(long[] indices, double[] data, boolean contiguous, long inc) {
        if (indices.length != data.length) {
            throw new IllegalArgumentException("Indices and data length must be the same");
        }
        if ((long)indices.length > this.length()) {
            throw new IllegalArgumentException("More elements than space to assign. This buffer is of length " + this.length() + " where the indices are of length " + data.length);
        }
        if (contiguous) {
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException("Only contiguous supported");
    }

    protected DataBuffer create(long length) {
        return new CudaBfloat16DataBuffer(length);
    }

    public float[] getFloatsAt(long offset, long inc, int length) {
        return super.getFloatsAt(offset, inc, length);
    }

    public double[] getDoublesAt(long offset, long inc, int length) {
        return ArrayUtil.toDoubles((float[])this.getFloatsAt(offset, inc, length));
    }

    @Override
    public void setData(float[] data) {
        this.setData(ArrayUtil.toShorts((float[])data));
    }

    @Override
    public void setData(int[] data) {
        this.setData(ArrayUtil.toShorts((int[])data));
    }

    @Override
    public void setData(long[] data) {
        this.setData(ArrayUtil.toShorts((long[])data));
    }

    @Override
    public void setData(double[] data) {
        this.setData(ArrayUtil.toFloats((double[])data));
    }

    public DataType dataType() {
        return DataType.BFLOAT16;
    }

    @Override
    public float[] asFloat() {
        return super.asFloat();
    }

    @Override
    public double[] asDouble() {
        return ArrayUtil.toDoubles((float[])this.asFloat());
    }

    @Override
    public int[] asInt() {
        return ArrayUtil.toInts((float[])this.asFloat());
    }

    @Override
    public double getDouble(long i) {
        return super.getFloat(i);
    }

    public DataBuffer create(double[] data) {
        return new CudaBfloat16DataBuffer(data);
    }

    public DataBuffer create(float[] data) {
        return new CudaBfloat16DataBuffer(data);
    }

    public DataBuffer create(int[] data) {
        return new CudaBfloat16DataBuffer(data);
    }

    @Override
    public void flush() {
    }
}

