/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.allocator.context;

import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.RandomUtils;
import org.nd4j.linalg.jcublas.context.CudaContext;

public class ContextPack {
    private Integer deviceId;
    private int availableLanes;
    private Map<Integer, CudaContext> lanes = new HashMap<Integer, CudaContext>();

    public ContextPack(int totalLanes) {
        this.availableLanes = totalLanes;
    }

    public ContextPack(CudaContext context) {
        this.availableLanes = 1;
        this.lanes.put(0, context);
    }

    public void addLane(@NonNull Integer laneId, @NonNull CudaContext context) {
        if (laneId == null) {
            throw new NullPointerException("laneId is marked @NonNull but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked @NonNull but is null");
        }
        this.lanes.put(laneId, context);
        context.setLaneId(laneId);
    }

    public CudaContext getContextForLane(Integer laneId) {
        return this.lanes.get(laneId);
    }

    public int nextRandomLane() {
        if (this.availableLanes == 1) {
            return 0;
        }
        return RandomUtils.nextInt((int)0, (int)this.availableLanes);
    }

    public Integer getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(Integer deviceId) {
        this.deviceId = deviceId;
    }

    public int getAvailableLanes() {
        return this.availableLanes;
    }
}

