/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.allocator.pointers;

import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CudaPointer
extends Pointer {
    private static Logger logger = LoggerFactory.getLogger(CudaPointer.class);

    public CudaPointer(Pointer pointer) {
        this.address = pointer.address();
        this.capacity = pointer.capacity();
        this.limit = pointer.limit();
        this.position = pointer.position();
    }

    public CudaPointer(Pointer pointer, long capacity) {
        this.address = pointer.address();
        this.capacity = capacity;
        this.limit = capacity;
        this.position = 0L;
    }

    public CudaPointer(Pointer pointer, long capacity, long byteOffset) {
        this.address = pointer.address() + byteOffset;
        this.capacity = capacity;
        this.limit = capacity;
        this.position = 0L;
    }

    public CudaPointer(long address) {
        this.address = address;
    }

    public CudaPointer(long address, long capacity) {
        this.address = address;
        this.capacity = capacity;
        this.limit = capacity;
        this.position = 0L;
    }

    public Pointer asNativePointer() {
        return new Pointer((Pointer)this);
    }

    public FloatPointer asFloatPointer() {
        return new FloatPointer((Pointer)this);
    }

    public LongPointer asLongPointer() {
        return new LongPointer((Pointer)this);
    }

    public DoublePointer asDoublePointer() {
        return new DoublePointer((Pointer)this);
    }

    public IntPointer asIntPointer() {
        return new IntPointer((Pointer)this);
    }

    public ShortPointer asShortPointer() {
        return new ShortPointer((Pointer)this);
    }

    public long getNativePointer() {
        return this.address();
    }

    public int sizeof() {
        return 4;
    }
}

