/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.allocator.utils;

import lombok.NonNull;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.jita.allocator.impl.AllocationShape;
import org.nd4j.jita.allocator.impl.AtomicAllocator;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.jcublas.buffer.CudaDoubleDataBuffer;
import org.nd4j.linalg.jcublas.buffer.JCudaBuffer;

public class AllocationUtils {
    public static long getRequiredMemory(@NonNull AllocationShape shape) {
        if (shape == null) {
            throw new NullPointerException("shape is marked @NonNull but is null");
        }
        return shape.getLength() * (long)AllocationUtils.getElementSize(shape);
    }

    public static int getElementSize(@NonNull AllocationShape shape) {
        if (shape == null) {
            throw new NullPointerException("shape is marked @NonNull but is null");
        }
        if (shape.getElementSize() > 0) {
            return shape.getElementSize();
        }
        return shape.getDataType() == DataBuffer.Type.FLOAT ? 4 : (shape.getDataType() == DataBuffer.Type.DOUBLE ? 8 : 2);
    }

    public static AllocationShape buildAllocationShape(INDArray array) {
        AllocationShape shape = new AllocationShape();
        shape.setStride(array.elementWiseStride());
        shape.setOffset(array.originalOffset());
        shape.setDataType(array.data().dataType());
        shape.setLength(array.length());
        shape.setDataType(array.data().dataType());
        return shape;
    }

    public static AllocationShape buildAllocationShape(DataBuffer buffer) {
        AllocationShape shape = new AllocationShape();
        shape.setStride(1);
        shape.setOffset(buffer.originalOffset());
        shape.setDataType(buffer.dataType());
        shape.setLength(buffer.length());
        return shape;
    }

    public static AllocationShape buildAllocationShape(JCudaBuffer buffer) {
        AllocationShape shape = new AllocationShape();
        shape.setStride(1);
        shape.setOffset(buffer.originalOffset());
        shape.setDataType(buffer.dataType());
        shape.setLength(buffer.length());
        return shape;
    }

    public static long getByteOffset(AllocationShape shape) {
        return shape.getOffset() * (long)AllocationUtils.getElementSize(shape);
    }

    public static DataBuffer getPointersBuffer(long[] pointers) {
        CudaDoubleDataBuffer tempX = new CudaDoubleDataBuffer(pointers.length);
        AtomicAllocator.getInstance().memcpyBlocking(tempX, (Pointer)new LongPointer(pointers), pointers.length * 8, 0L);
        return tempX;
    }
}

