/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.memory;

import java.util.Map;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.jita.allocator.enums.AllocationStatus;
import org.nd4j.jita.allocator.impl.AllocationPoint;
import org.nd4j.jita.allocator.impl.AtomicAllocator;
import org.nd4j.jita.conf.CudaEnvironment;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.memory.enums.MemoryKind;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.compression.CompressedDataBuffer;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.jcublas.context.CudaContext;
import org.nd4j.linalg.memory.BasicMemoryManager;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CudaMemoryManager
extends BasicMemoryManager {
    private static final Logger log = LoggerFactory.getLogger(CudaMemoryManager.class);

    public Pointer allocate(long bytes, MemoryKind kind, boolean initialize) {
        AtomicAllocator allocator = AtomicAllocator.getInstance();
        if (kind == MemoryKind.HOST) {
            Pointer ptr = NativeOpsHolder.getInstance().getDeviceNativeOps().mallocHost(bytes, 0);
            if (ptr == null) {
                throw new RuntimeException("Failed to allocate " + bytes + " bytes from HOST memory");
            }
            if (initialize) {
                Pointer.memset((Pointer)ptr, (int)0, (long)bytes);
            }
            return ptr;
        }
        if (kind == MemoryKind.DEVICE) {
            Pointer ptr = NativeOpsHolder.getInstance().getDeviceNativeOps().mallocDevice(bytes, null, 0);
            if (ptr == null) {
                throw new RuntimeException("Failed to allocate " + bytes + " bytes from DEVICE [" + Nd4j.getAffinityManager().getDeviceForCurrentThread() + "] memory");
            }
            if (initialize) {
                CudaContext context = (CudaContext)AtomicAllocator.getInstance().getDeviceContext().getContext();
                int i = NativeOpsHolder.getInstance().getDeviceNativeOps().memsetAsync(ptr, 0, bytes, 0, (Pointer)context.getSpecialStream());
                if (i == 0) {
                    throw new ND4JIllegalStateException("memset failed on device_" + Nd4j.getAffinityManager().getDeviceForCurrentThread());
                }
                context.getSpecialStream().synchronize();
            }
            return ptr;
        }
        throw new RuntimeException("Unknown MemoryKind requested: " + kind);
    }

    public void collect(INDArray ... arrays) {
        Nd4j.getExecutioner().commit();
        int cnt = -1;
        AtomicAllocator allocator = AtomicAllocator.getInstance();
        for (INDArray array : arrays) {
            ++cnt;
            if (array == null || array.isView()) continue;
            AllocationPoint point = allocator.getAllocationPoint(array);
            if (point.getAllocationStatus() == AllocationStatus.HOST) {
                allocator.getMemoryHandler().free(point, AllocationStatus.HOST);
            } else if (point.getAllocationStatus() == AllocationStatus.DEVICE) {
                allocator.getMemoryHandler().free(point, AllocationStatus.DEVICE);
                allocator.getMemoryHandler().free(point, AllocationStatus.HOST);
            } else if (point.getAllocationStatus() != AllocationStatus.DEALLOCATED) {
                throw new RuntimeException("Unknown AllocationStatus: " + (Object)((Object)point.getAllocationStatus()) + " for argument: " + cnt);
            }
            point.setAllocationStatus(AllocationStatus.DEALLOCATED);
        }
    }

    public synchronized void purgeCaches() {
        AtomicAllocator.getInstance().getMemoryHandler().getMemoryProvider().purgeCache();
    }

    public void memcpy(DataBuffer dstBuffer, DataBuffer srcBuffer) {
        CudaContext context = (CudaContext)AtomicAllocator.getInstance().getDeviceContext().getContext();
        if (dstBuffer instanceof CompressedDataBuffer && !(srcBuffer instanceof CompressedDataBuffer)) {
            AllocationPoint srcPoint = AtomicAllocator.getInstance().getAllocationPoint(srcBuffer);
            long size = (long)srcBuffer.getElementSize() * srcBuffer.length();
            if (!srcPoint.isActualOnHostSide()) {
                AtomicAllocator.getInstance().synchronizeHostData(srcBuffer);
            }
            Pointer src = AtomicAllocator.getInstance().getHostPointer(srcBuffer);
            Pointer.memcpy((Pointer)dstBuffer.addressPointer(), (Pointer)src, (long)size);
        } else if (!(dstBuffer instanceof CompressedDataBuffer) && srcBuffer instanceof CompressedDataBuffer) {
            AllocationPoint dstPoint = AtomicAllocator.getInstance().getAllocationPoint(dstBuffer);
            long size = (long)srcBuffer.getElementSize() * srcBuffer.length();
            Pointer.memcpy((Pointer)dstBuffer.addressPointer(), (Pointer)srcBuffer.addressPointer(), (long)size);
            dstPoint.tickHostWrite();
        } else if (dstBuffer instanceof CompressedDataBuffer && srcBuffer instanceof CompressedDataBuffer) {
            Pointer.memcpy((Pointer)dstBuffer.addressPointer(), (Pointer)srcBuffer.addressPointer(), (long)(srcBuffer.length() * (long)srcBuffer.getElementSize()));
        } else {
            AtomicAllocator.getInstance().memcpy(dstBuffer, srcBuffer);
        }
    }

    public void release(Pointer pointer, MemoryKind kind) {
        if (kind == MemoryKind.DEVICE) {
            NativeOpsHolder.getInstance().getDeviceNativeOps().freeDevice(pointer, null);
        } else if (kind == MemoryKind.HOST) {
            NativeOpsHolder.getInstance().getDeviceNativeOps().freeHost(pointer);
        }
    }

    public void setAutoGcWindow(int windowMillis) {
        super.setAutoGcWindow(windowMillis);
        CudaEnvironment.getInstance().getConfiguration().setNoGcWindowMs(windowMillis);
    }

    public void memset(INDArray array) {
        if (array.isView()) {
            array.assign((Number)0.0);
            Nd4j.getExecutioner().commit();
            return;
        }
        Nd4j.getExecutioner().push();
        AllocationPoint point = AtomicAllocator.getInstance().getAllocationPoint(array);
        if (point.getAllocationStatus() == AllocationStatus.DEVICE) {
            CudaContext context = (CudaContext)AtomicAllocator.getInstance().getDeviceContext().getContext();
            NativeOpsHolder.getInstance().getDeviceNativeOps().memsetAsync(AtomicAllocator.getInstance().getPointer(array, context), 0, array.data().length() * (long)Nd4j.sizeOfDataType((DataBuffer.Type)array.data().dataType()), 0, (Pointer)context.getOldStream());
            Pointer.memset((Pointer)AtomicAllocator.getInstance().getHostPointer(array), (int)0, (long)(array.data().length() * (long)Nd4j.sizeOfDataType((DataBuffer.Type)array.data().dataType())));
            context.getOldStream().synchronize();
            point.tickDeviceWrite();
            point.tickHostRead();
        } else if (point.getAllocationStatus() == AllocationStatus.HOST) {
            Nd4j.getExecutioner().commit();
            Pointer.memset((Pointer)AtomicAllocator.getInstance().getHostPointer(array), (int)0, (long)(array.data().length() * (long)Nd4j.sizeOfDataType((DataBuffer.Type)array.data().dataType())));
            point.tickHostWrite();
        }
    }

    public Map<Integer, Long> getBandwidthUse() {
        return null;
    }
}

