/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.annotations.documented;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.neo4j.annotations.documented.DocumentedUtils;
import org.neo4j.annotations.documented.ReporterFactory;

public class ReporterFactories {
    private static final InvocationHandler throwingHandler = new ThrowingInvocationHandler();
    private static final InvocationHandler noopHandler = (proxy, method, args) -> null;

    public static ReporterFactory throwingReporterFactory() {
        return new ReporterFactory(throwingHandler);
    }

    public static ReporterFactory noopReporterFactory() {
        return new ReporterFactory(noopHandler);
    }

    private static class ThrowingInvocationHandler
    implements InvocationHandler {
        private ThrowingInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            throw new RuntimeException(DocumentedUtils.extractFormattedMessage(method, args));
        }
    }
}

