/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.input.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.server.http.cypher.format.api.InputFormatException;
import org.neo4j.server.http.cypher.format.input.json.InputStatement;
import org.neo4j.server.http.cypher.format.input.json.StatementDeserializer;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.string.UTF8;

class StatementDeserializerTest {
    private final JsonFactory jsonFactory = new JsonFactory().setCodec((ObjectCodec)new ObjectMapper());

    StatementDeserializerTest() {
    }

    @Test
    void shouldDeserializeSingleStatement() {
        String json = JsonHelper.createJsonFrom((Object)MapUtil.map((Object[])new Object[]{"statements", Collections.singletonList(MapUtil.map((Object[])new Object[]{"statement", "Blah blah", "parameters", MapUtil.map((Object[])new Object[]{"one", 12})}))}));
        StatementDeserializer de = new StatementDeserializer(this.jsonFactory, (InputStream)new ByteArrayInputStream(UTF8.encode((String)json)));
        InputStatement stmt = de.read();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)stmt);
        Assertions.assertThat((String)stmt.statement()).isEqualTo("Blah blah");
        Assertions.assertThat((Map)stmt.parameters()).isEqualTo((Object)MapUtil.map((Object[])new Object[]{"one", 12}));
        org.junit.jupiter.api.Assertions.assertNull((Object)de.read());
    }

    @Test
    void shouldRejectMapWithADifferentFieldBeforeStatement() {
        String json = "{ \"timeout\" : 200, \"statements\" : [ { \"statement\" : \"ignored\", \"parameters\" : {}} ] }";
        this.assertYieldsErrors(json, "Unable to deserialize request. Expected first field to be 'statements', but was 'timeout'.");
    }

    @Test
    void shouldTotallyIgnoreInvalidJsonAfterStatementArrayHasFinished() {
        String json = "{ \"statements\" : [ { \"statement\" : \"Blah blah\", \"parameters\" : {\"one\" : 12}} ] totally invalid json is totally ignored";
        StatementDeserializer de = new StatementDeserializer(this.jsonFactory, (InputStream)new ByteArrayInputStream(UTF8.encode((String)json)));
        InputStatement stmt = de.read();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)stmt);
        Assertions.assertThat((String)stmt.statement()).isEqualTo("Blah blah");
        org.junit.jupiter.api.Assertions.assertNull((Object)de.read());
    }

    @Test
    void shouldIgnoreUnknownFields() {
        String json = "{ \"statements\" : [ { \"a\" : \"\", \"b\" : { \"k\":1 }, \"statement\" : \"blah\" } ] }";
        StatementDeserializer de = new StatementDeserializer(this.jsonFactory, (InputStream)new ByteArrayInputStream(UTF8.encode((String)json)));
        InputStatement stmt = de.read();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)stmt);
        Assertions.assertThat((String)stmt.statement()).isEqualTo("blah");
        org.junit.jupiter.api.Assertions.assertNull((Object)de.read());
    }

    @Test
    void shouldTakeParametersBeforeStatement() {
        String json = "{ \"statements\" : [ { \"a\" : \"\", \"parameters\" : { \"k\":1 }, \"statement\" : \"blah\"}]}";
        StatementDeserializer de = new StatementDeserializer(this.jsonFactory, (InputStream)new ByteArrayInputStream(UTF8.encode((String)json)));
        InputStatement stmt = de.read();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)stmt);
        Assertions.assertThat((String)stmt.statement()).isEqualTo("blah");
        Assertions.assertThat((Map)stmt.parameters()).isEqualTo((Object)MapUtil.map((Object[])new Object[]{"k", 1}));
        org.junit.jupiter.api.Assertions.assertNull((Object)de.read());
    }

    @Test
    void shouldTreatEmptyInputStreamAsEmptyStatementList() {
        byte[] json = new byte[]{};
        StatementDeserializer de = new StatementDeserializer(this.jsonFactory, (InputStream)new ByteArrayInputStream(json));
        org.junit.jupiter.api.Assertions.assertNull((Object)de.read());
    }

    @Test
    void shouldDeserializeMultipleStatements() {
        String json = JsonHelper.createJsonFrom((Object)MapUtil.map((Object[])new Object[]{"statements", Arrays.asList(MapUtil.map((Object[])new Object[]{"statement", "Blah blah", "parameters", MapUtil.map((Object[])new Object[]{"one", 12})}), MapUtil.map((Object[])new Object[]{"statement", "Blah bluh", "parameters", MapUtil.map((Object[])new Object[]{"asd", Collections.singletonList("one, two")})}))}));
        StatementDeserializer de = new StatementDeserializer(this.jsonFactory, (InputStream)new ByteArrayInputStream(UTF8.encode((String)json)));
        InputStatement stmt = de.read();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)stmt);
        Assertions.assertThat((String)stmt.statement()).isEqualTo("Blah blah");
        Assertions.assertThat((Map)stmt.parameters()).isEqualTo((Object)MapUtil.map((Object[])new Object[]{"one", 12}));
        InputStatement stmt2 = de.read();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)stmt2);
        Assertions.assertThat((String)stmt2.statement()).isEqualTo("Blah bluh");
        Assertions.assertThat((Map)stmt2.parameters()).isEqualTo((Object)MapUtil.map((Object[])new Object[]{"asd", Collections.singletonList("one, two")}));
        org.junit.jupiter.api.Assertions.assertNull((Object)de.read());
    }

    @Test
    void shouldNotThrowButReportErrorOnInvalidInput() {
        this.assertYieldsErrors("{}", "Unable to deserialize request. Expected [START_OBJECT, FIELD_NAME, START_ARRAY], found [START_OBJECT, END_OBJECT, null].");
        this.assertYieldsErrors("{ \"statements\":\"WAIT WAT A STRING NOO11!\" }", "Unable to deserialize request. Expected [START_OBJECT, FIELD_NAME, START_ARRAY], found [START_OBJECT, FIELD_NAME, VALUE_STRING].");
        this.assertYieldsErrors("[{]}", "Could not parse the incoming JSON", "Unexpected close marker ']': expected '}' (for Object starting at [Source: (ByteArrayInputStream); line: 1, column: 2])\n at [Source: (ByteArrayInputStream); line: 1, column: 4]");
        this.assertYieldsErrors("{ \"statements\" : \"ITS A STRING\" }", "Unable to deserialize request. Expected [START_OBJECT, FIELD_NAME, START_ARRAY], found [START_OBJECT, FIELD_NAME, VALUE_STRING].");
        this.assertYieldsErrors("{ \"statements\" : [ { \"statement\" : [\"dd\"] } ] }", "Could not map the incoming JSON", "Cannot deserialize value of type `java.lang.String` from Array value (token `JsonToken.START_ARRAY`)\n at [Source: (ByteArrayInputStream); line: 1, column: 36]");
        this.assertYieldsErrors("{ \"statements\" : [ { \"statement\" : \"stmt\", \"parameters\" : [\"AN ARRAY!!\"] } ] }", "Could not map the incoming JSON", "Cannot deserialize value of type `java.util.LinkedHashMap<java.lang.Object,java.lang.Object>` from Array value (token `JsonToken.START_ARRAY`)\n at [Source: (ByteArrayInputStream); line: 1, column: 59]");
    }

    private void assertYieldsErrors(String json, String ... expectedErrorMessages) {
        StatementDeserializer de = new StatementDeserializer(this.jsonFactory, (InputStream)new ByteArrayInputStream(UTF8.encode((String)json)));
        try {
            while (de.read() != null) {
            }
            org.junit.jupiter.api.Assertions.fail((String)"An exception should have been thrown");
        }
        catch (InputFormatException e) {
            ArrayList<String> errorMessages = new ArrayList<String>();
            errorMessages.add(e.getMessage());
            Throwable t = e;
            while ((t = t.getCause()) != null) {
                errorMessages.add(t.getMessage());
            }
            Assertions.assertThat(errorMessages).isEqualTo(Arrays.asList(expectedErrorMessages));
        }
    }
}

