/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.InternalLog;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.server.http.cypher.ErrorInvocation;
import org.neo4j.server.http.cypher.HttpTransactionManager;
import org.neo4j.server.http.cypher.Invocation;
import org.neo4j.server.http.cypher.OutputEventStreamImpl;
import org.neo4j.server.http.cypher.RollbackInvocation;
import org.neo4j.server.http.cypher.TransactionFacade;
import org.neo4j.server.http.cypher.TransactionHandle;
import org.neo4j.server.http.cypher.TransactionLifecycleException;
import org.neo4j.server.http.cypher.format.api.InputEventStream;
import org.neo4j.server.http.cypher.format.api.TransactionUriScheme;
import org.neo4j.server.rest.Neo4jError;
import org.neo4j.server.rest.dbms.AuthorizedRequestWrapper;
import org.neo4j.server.web.HttpHeaderUtils;
import org.neo4j.time.SystemNanoClock;

public abstract class AbstractCypherResource {
    private final HttpTransactionManager httpTransactionManager;
    private final TransactionUriScheme uriScheme;
    private final MemoryPool memoryPool;
    private final InternalLog log;
    private final String databaseName;
    private final SystemNanoClock clock;

    AbstractCypherResource(HttpTransactionManager httpTransactionManager, UriInfo uriInfo, MemoryPool memoryPool, InternalLog log, String databaseName, SystemNanoClock clock) {
        this.httpTransactionManager = httpTransactionManager;
        this.databaseName = databaseName;
        this.uriScheme = new TransactionUriBuilder(this.dbUri(uriInfo, databaseName), this.cypherUri(uriInfo, databaseName));
        this.memoryPool = memoryPool;
        this.log = log;
        this.clock = clock;
    }

    protected abstract URI dbUri(UriInfo var1, String var2);

    protected abstract URI cypherUri(UriInfo var1, String var2);

    /*
     * Loose catch block
     */
    @POST
    public Response executeStatementsInNewTransaction(InputEventStream inputEventStream, @Context HttpServletRequest request, @Context HttpHeaders headers) {
        try (MemoryTracker memoryTracker = this.createMemoryTracker();){
            InputEventStream inputStream = AbstractCypherResource.ensureNotNull(inputEventStream);
            try {
                Optional<GraphDatabaseAPI> graphDatabaseAPI = this.httpTransactionManager.getGraphDatabaseAPI(this.databaseName);
                Response response = graphDatabaseAPI.map(databaseAPI -> {
                    if (AbstractCypherResource.isDatabaseNotAvailable(databaseAPI)) {
                        return this.createNonAvailableDatabaseResponse(inputStream.getParameters());
                    }
                    memoryTracker.allocateHeap(Invocation.SHALLOW_SIZE);
                    TransactionFacade transactionFacade = this.httpTransactionManager.createTransactionFacade((GraphDatabaseAPI)databaseAPI, memoryTracker, this.databaseName);
                    TransactionHandle transactionHandle = this.createNewTransactionHandle(transactionFacade, request, headers, memoryTracker, false);
                    Invocation invocation = new Invocation(this.log, transactionHandle, this.uriScheme.txCommitUri(transactionHandle.getId()), this.memoryPool, inputStream, false);
                    OutputEventStreamImpl outputStream = new OutputEventStreamImpl(inputStream.getParameters(), this.uriScheme, invocation::execute);
                    return Response.created((URI)transactionHandle.uri()).entity((Object)outputStream).build();
                }).orElse(this.createNonExistentDatabaseResponse(inputStream.getParameters()));
                return response;
            }
            catch (IllegalArgumentException ex) {
                Response response;
                block12: {
                    response = this.createInvalidAccessModeHeaderResponse(ex);
                    if (memoryTracker == null) break block12;
                    memoryTracker.close();
                }
                return response;
            }
            catch (RuntimeException ex) {
                block13: {
                    Response response;
                    block14: {
                        if (!(ex instanceof Status.HasStatus)) break block13;
                        response = this.createGenericErrorDatabaseResponse(inputStream.getParameters(), ((Status.HasStatus)ex).status(), ex.getMessage());
                        if (memoryTracker == null) break block14;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        memoryTracker.close();
                    }
                    return response;
                }
                throw ex;
            }
        }
    }

    @POST
    @Path(value="/{id}")
    public Response executeStatements(@PathParam(value="id") long id, InputEventStream inputEventStream, @Context HttpServletRequest request) {
        try (MemoryTracker memoryTracker = this.createMemoryTracker();){
            Response response = this.executeInExistingTransaction(id, inputEventStream, memoryTracker, false, AuthorizedRequestWrapper.getLoginContextFromHttpServletRequest(request));
            return response;
        }
    }

    @POST
    @Path(value="/{id}/commit")
    public Response commitTransaction(@PathParam(value="id") long id, InputEventStream inputEventStream, @Context HttpServletRequest request) {
        try (MemoryTracker memoryTracker = this.createMemoryTracker();){
            Response response = this.executeInExistingTransaction(id, inputEventStream, memoryTracker, true, AuthorizedRequestWrapper.getLoginContextFromHttpServletRequest(request));
            return response;
        }
    }

    /*
     * Loose catch block
     */
    @POST
    @Path(value="/commit")
    public Response commitNewTransaction(InputEventStream inputEventStream, @Context HttpServletRequest request, @Context HttpHeaders headers) {
        try (MemoryTracker memoryTracker = this.createMemoryTracker();){
            InputEventStream inputStream = AbstractCypherResource.ensureNotNull(inputEventStream);
            try {
                Optional<GraphDatabaseAPI> graphDatabaseAPI = this.httpTransactionManager.getGraphDatabaseAPI(this.databaseName);
                Response response = graphDatabaseAPI.map(databaseAPI -> {
                    if (AbstractCypherResource.isDatabaseNotAvailable(databaseAPI)) {
                        return this.createNonAvailableDatabaseResponse(inputStream.getParameters());
                    }
                    memoryTracker.allocateHeap(Invocation.SHALLOW_SIZE);
                    TransactionFacade transactionFacade = this.httpTransactionManager.createTransactionFacade((GraphDatabaseAPI)databaseAPI, memoryTracker, this.databaseName);
                    TransactionHandle transactionHandle = this.createNewTransactionHandle(transactionFacade, request, headers, memoryTracker, true);
                    Invocation invocation = new Invocation(this.log, transactionHandle, null, this.memoryPool, inputStream, true);
                    OutputEventStreamImpl outputStream = new OutputEventStreamImpl(inputStream.getParameters(), this.uriScheme, invocation::execute);
                    return Response.ok((Object)outputStream).build();
                }).orElse(this.createNonExistentDatabaseResponse(inputStream.getParameters()));
                return response;
            }
            catch (IllegalArgumentException ex) {
                Response response;
                block12: {
                    response = this.createInvalidAccessModeHeaderResponse(ex);
                    if (memoryTracker == null) break block12;
                    memoryTracker.close();
                }
                return response;
            }
            catch (RuntimeException ex) {
                block13: {
                    Response response;
                    block14: {
                        if (!(ex instanceof Status.HasStatus)) break block13;
                        response = this.createGenericErrorDatabaseResponse(inputStream.getParameters(), ((Status.HasStatus)ex).status(), ex.getMessage());
                        if (memoryTracker == null) break block14;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        memoryTracker.close();
                    }
                    return response;
                }
                throw ex;
            }
        }
    }

    @DELETE
    @Path(value="/{id}")
    public Response rollbackTransaction(@PathParam(value="id") long id, @Context HttpServletRequest request) {
        Response response;
        block9: {
            MemoryTracker memoryTracker = this.createMemoryTracker();
            try {
                Optional<GraphDatabaseAPI> graphDatabaseAPI = this.httpTransactionManager.getGraphDatabaseAPI(this.databaseName);
                response = graphDatabaseAPI.map(databaseAPI -> {
                    TransactionHandle transactionHandle;
                    if (AbstractCypherResource.isDatabaseNotAvailable(databaseAPI)) {
                        return this.createNonAvailableDatabaseResponse(Collections.emptyMap());
                    }
                    memoryTracker.allocateHeap(RollbackInvocation.SHALLOW_SIZE);
                    TransactionFacade transactionFacade = this.httpTransactionManager.createTransactionFacade((GraphDatabaseAPI)databaseAPI, memoryTracker, this.databaseName);
                    try {
                        transactionHandle = transactionFacade.terminate(id, AuthorizedRequestWrapper.getLoginContextFromHttpServletRequest(request));
                    }
                    catch (TransactionLifecycleException e) {
                        return this.invalidTransaction(e, Collections.emptyMap());
                    }
                    RollbackInvocation invocation = new RollbackInvocation(this.log, transactionHandle);
                    OutputEventStreamImpl outputEventStream = new OutputEventStreamImpl(Collections.emptyMap(), this.uriScheme, invocation::execute);
                    return Response.ok().entity((Object)outputEventStream).build();
                }).orElse(this.createNonExistentDatabaseResponse(Collections.emptyMap()));
                if (memoryTracker == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (memoryTracker != null) {
                        try {
                            memoryTracker.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException ex) {
                    if (ex instanceof Status.HasStatus) {
                        return this.createGenericErrorDatabaseResponse(Collections.emptyMap(), ((Status.HasStatus)ex).status(), ex.getMessage());
                    }
                    throw ex;
                }
            }
            memoryTracker.close();
        }
        return response;
    }

    private MemoryTracker createMemoryTracker() {
        return new LocalMemoryTracker(this.memoryPool, 0L, 64L, null);
    }

    private static boolean isDatabaseNotAvailable(GraphDatabaseAPI databaseAPI) {
        return !databaseAPI.isAvailable();
    }

    private TransactionHandle createNewTransactionHandle(TransactionFacade transactionFacade, HttpServletRequest request, HttpHeaders headers, MemoryTracker memoryTracker, boolean implicitTransaction) {
        LoginContext loginContext = AuthorizedRequestWrapper.getLoginContextFromHttpServletRequest(request);
        long customTransactionTimeout = HttpHeaderUtils.getTransactionTimeout(headers, this.log);
        Optional<Boolean> isReadOnlyTransaction = HttpHeaderUtils.getAccessMode(headers);
        List<String> bookmarks = HttpHeaderUtils.getBookmarks(headers);
        if (isReadOnlyTransaction.isPresent()) {
            return transactionFacade.newTransactionHandle(this.uriScheme, implicitTransaction, loginContext, loginContext.connectionInfo(), memoryTracker, customTransactionTimeout, this.clock, isReadOnlyTransaction.get(), bookmarks);
        }
        return transactionFacade.newTransactionHandle(this.uriScheme, implicitTransaction, loginContext, loginContext.connectionInfo(), memoryTracker, customTransactionTimeout, bookmarks);
    }

    private Response executeInExistingTransaction(long transactionId, InputEventStream inputEventStream, MemoryTracker memoryTracker, boolean finishWithCommit, LoginContext requestingUserLoginContext) {
        InputEventStream inputStream = AbstractCypherResource.ensureNotNull(inputEventStream);
        try {
            Optional<GraphDatabaseAPI> graphDatabaseAPI = this.httpTransactionManager.getGraphDatabaseAPI(this.databaseName);
            return graphDatabaseAPI.map(databaseAPI -> {
                TransactionHandle transactionHandle;
                if (AbstractCypherResource.isDatabaseNotAvailable(databaseAPI)) {
                    return this.createNonAvailableDatabaseResponse(inputStream.getParameters());
                }
                memoryTracker.allocateHeap(Invocation.SHALLOW_SIZE);
                TransactionFacade transactionFacade = this.httpTransactionManager.createTransactionFacade((GraphDatabaseAPI)databaseAPI, memoryTracker, this.databaseName);
                try {
                    transactionHandle = transactionFacade.findTransactionHandle(transactionId, requestingUserLoginContext);
                }
                catch (TransactionLifecycleException e) {
                    return this.invalidTransaction(e, inputStream.getParameters());
                }
                Invocation invocation = new Invocation(this.log, transactionHandle, this.uriScheme.txCommitUri(transactionHandle.getId()), this.memoryPool, inputStream, finishWithCommit);
                OutputEventStreamImpl outputEventStream = new OutputEventStreamImpl(inputStream.getParameters(), this.uriScheme, invocation::execute);
                return Response.ok((Object)outputEventStream).build();
            }).orElse(this.createNonExistentDatabaseResponse(inputStream.getParameters()));
        }
        catch (RuntimeException ex) {
            if (ex instanceof Status.HasStatus) {
                return this.createGenericErrorDatabaseResponse(inputStream.getParameters(), ((Status.HasStatus)ex).status(), ex.getMessage());
            }
            throw ex;
        }
    }

    private Response invalidTransaction(TransactionLifecycleException e, Map<String, Object> parameters) {
        ErrorInvocation errorInvocation = new ErrorInvocation(e.toNeo4jError());
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new OutputEventStreamImpl(parameters, this.uriScheme, errorInvocation::execute)).build();
    }

    private static InputEventStream ensureNotNull(InputEventStream inputEventStream) {
        return Objects.requireNonNullElse(inputEventStream, InputEventStream.EMPTY);
    }

    private Response createGenericErrorDatabaseResponse(Map<String, Object> parameters, Status status, String msg) {
        ErrorInvocation errorInvocation = new ErrorInvocation(new Neo4jError(status, msg));
        return Response.ok((Object)new OutputEventStreamImpl(parameters, this.uriScheme, errorInvocation::execute)).build();
    }

    private Response createNonExistentDatabaseResponse(Map<String, Object> parameters) {
        ErrorInvocation errorInvocation = new ErrorInvocation(new Neo4jError((Status)Status.Database.DatabaseNotFound, String.format("The database requested does not exists. Requested database name: '%s'.", this.databaseName)));
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new OutputEventStreamImpl(parameters, this.uriScheme, errorInvocation::execute)).build();
    }

    private Response createNonAvailableDatabaseResponse(Map<String, Object> parameters) {
        ErrorInvocation errorInvocation = new ErrorInvocation(new Neo4jError((Status)Status.General.DatabaseUnavailable, String.format("Requested database is not available. Requested database name: '%s'.", this.databaseName)));
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new OutputEventStreamImpl(parameters, this.uriScheme, errorInvocation::execute)).build();
    }

    private Response createInvalidAccessModeHeaderResponse(IllegalArgumentException ex) {
        ErrorInvocation errorInvocation = new ErrorInvocation(new Neo4jError((Status)Status.Request.InvalidFormat, ex.getMessage()));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new OutputEventStreamImpl(Collections.emptyMap(), this.uriScheme, errorInvocation::execute)).build();
    }

    private static class TransactionUriBuilder
    implements TransactionUriScheme {
        private final URI dbUri;
        private final URI cypherUri;

        TransactionUriBuilder(URI dbUri, URI cypherUri) {
            this.dbUri = dbUri;
            this.cypherUri = cypherUri;
        }

        @Override
        public URI txUri(long id) {
            return this.transactionBuilder(id).build(new Object[0]);
        }

        @Override
        public URI txCommitUri(long id) {
            return this.transactionBuilder(id).path("/commit").build(new Object[0]);
        }

        @Override
        public URI dbUri() {
            return this.dbUri;
        }

        private UriBuilder transactionBuilder(long id) {
            return UriBuilder.fromUri((URI)this.cypherUri).path("/" + id);
        }
    }
}

