/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.util.List;
import org.neo4j.configuration.Config;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.httpv2.QueryResource;
import org.neo4j.server.httpv2.metrics.QueryAPIMetricsFilter;
import org.neo4j.server.httpv2.metrics.QueryAPIMetricsMonitor;
import org.neo4j.server.httpv2.request.JsonMessageBodyReader;
import org.neo4j.server.httpv2.request.TypedJsonMessageBodyReader;
import org.neo4j.server.httpv2.response.PlainJsonDriverResultWriter;
import org.neo4j.server.httpv2.response.TypedJsonDriverResultWriter;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.web.WebServer;

public class QueryModule
implements ServerModule {
    private final WebServer webServer;
    private final Config config;
    private final QueryAPIMetricsMonitor metricsMonitor;

    public QueryModule(WebServer webServer, Config config, QueryAPIMetricsMonitor metricsMonitor) {
        this.webServer = webServer;
        this.config = config;
        this.metricsMonitor = metricsMonitor;
    }

    @Override
    public void start() {
        this.webServer.addJAXRSClasses(QueryModule.jaxRsClasses(), ((URI)this.config.get(ServerSettings.db_api_path)).toString(), null);
        this.webServer.addFilter(new QueryAPIMetricsFilter(this.metricsMonitor, ((URI)this.config.get(ServerSettings.db_api_path)).toString()), "/*");
    }

    @Override
    public void stop() {
        this.webServer.removeJAXRSClasses(QueryModule.jaxRsClasses(), ((URI)this.config.get(ServerSettings.db_api_path)).toString());
    }

    private static List<Class<?>> jaxRsClasses() {
        return List.of(QueryResource.class, PlainJsonDriverResultWriter.class, TypedJsonDriverResultWriter.class, JsonMessageBodyReader.class, TypedJsonMessageBodyReader.class);
    }
}

