/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.util.Collections;
import java.util.List;
import org.neo4j.configuration.Config;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.web.WebServer;

public class ThirdPartyJAXRSModule
implements ServerModule {
    private final Config config;
    private final WebServer webServer;
    private List<ThirdPartyJaxRsPackage> packages;
    private final InternalLog log;

    public ThirdPartyJAXRSModule(WebServer webServer, Config config, InternalLogProvider logProvider) {
        this.webServer = webServer;
        this.config = config;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public void start() {
        this.packages = (List)this.config.get(ServerSettings.third_party_packages);
        for (ThirdPartyJaxRsPackage tpp : this.packages) {
            List<String> packageNames = ThirdPartyJAXRSModule.packagesFor(tpp);
            this.webServer.addJAXRSPackages(packageNames, tpp.mountPoint(), null);
            this.log.info("Mounted unmanaged extension [%s] at [%s]", new Object[]{tpp.packageName(), tpp.mountPoint()});
        }
    }

    private static List<String> packagesFor(ThirdPartyJaxRsPackage tpp) {
        return Collections.singletonList(tpp.packageName());
    }

    @Override
    public void stop() {
        if (this.packages == null) {
            return;
        }
        for (ThirdPartyJaxRsPackage tpp : this.packages) {
            this.webServer.removeJAXRSPackages(ThirdPartyJAXRSModule.packagesFor(tpp), tpp.mountPoint());
        }
    }
}

